/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebeaninternal.server.deploy.BeanCascadeInfo;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.parse.AnnotationBase;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.validation.groups.Default;

public abstract class AnnotationParser
extends AnnotationBase {
    final DeployBeanInfo<?> info;
    final DeployBeanDescriptor<?> descriptor;
    final Class<?> beanType;
    final boolean validationAnnotations;
    final ReadAnnotationConfig readConfig;

    AnnotationParser(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig) {
        super(info.getUtil());
        this.readConfig = readConfig;
        this.validationAnnotations = readConfig.isJavaxValidationAnnotations();
        this.info = info;
        this.beanType = info.getDescriptor().getBeanType();
        this.descriptor = info.getDescriptor();
    }

    @Override
    public abstract void parse();

    void readIdAssocOne(DeployBeanPropertyAssoc<?> prop) {
        prop.setNullable(false);
        if (prop.isIdClass()) {
            prop.setImportedPrimaryKey();
        } else {
            prop.setId();
            prop.setEmbedded();
            this.info.setEmbeddedId(prop);
        }
    }

    void readIdScalar(DeployBeanProperty prop) {
        prop.setNullable(false);
        if (prop.isIdClass()) {
            prop.setImportedPrimaryKey();
        } else {
            prop.setId();
            if (prop.getPropertyType().equals(UUID.class) && this.readConfig.isIdGeneratorAutomatic()) {
                this.descriptor.setUuidGenerator();
            }
        }
    }

    void setCascadeTypes(CascadeType[] cascadeTypes, BeanCascadeInfo cascadeInfo) {
        if (cascadeTypes != null && cascadeTypes.length > 0) {
            cascadeInfo.setTypes(cascadeTypes);
        }
    }

    void readEmbeddedAttributeOverrides(DeployBeanPropertyAssocOne<?> prop) {
        Set<AttributeOverride> attrOverrides = this.annotationAttributeOverrides(prop);
        if (!attrOverrides.isEmpty()) {
            HashMap<String, Column> propMap = new HashMap<String, Column>(attrOverrides.size());
            for (AttributeOverride attrOverride : attrOverrides) {
                propMap.put(attrOverride.name(), attrOverride.column());
            }
            prop.getDeployEmbedded().putAll(propMap);
        }
    }

    void readColumn(Column columnAnn, DeployBeanProperty prop) {
        this.setColumnName(prop, columnAnn.name());
        prop.setDbInsertable(columnAnn.insertable());
        prop.setDbUpdateable(columnAnn.updatable());
        prop.setNullable(columnAnn.nullable());
        prop.setUnique(columnAnn.unique());
        if (columnAnn.precision() > 0) {
            prop.setDbLength(columnAnn.precision());
        } else if (columnAnn.length() != 255) {
            prop.setDbLength(columnAnn.length());
        }
        prop.setDbScale(columnAnn.scale());
        prop.setDbColumnDefn(columnAnn.columnDefinition());
        String baseTable = this.descriptor.getBaseTable();
        String tableName = columnAnn.table();
        if (!"".equals(tableName) && !tableName.equalsIgnoreCase(baseTable)) {
            prop.setSecondaryTable(tableName);
        }
    }

    protected void setColumnName(DeployBeanProperty prop, String name) {
        if (!this.isEmpty(name)) {
            prop.setDbColumn(this.databasePlatform.convertQuotedIdentifiers(name));
        }
    }

    boolean isEbeanValidationGroups(Class<?>[] groups) {
        if (!this.util.isUseJavaxValidationNotNull()) {
            return false;
        }
        return groups.length == 0 || groups.length == 1 && Default.class.isAssignableFrom(groups[0]);
    }

    String[] convertColumnNames(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.databasePlatform.convertQuotedIdentifiers(columnNames[i]);
        }
        return columnNames;
    }
}

