/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonSet {
    public static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docPropertyType, boolean nullable) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docPropertyType, nullable);
                }
                case 5001: {
                    return new Json(docPropertyType, nullable);
                }
            }
        }
        return new Varchar(docPropertyType, nullable);
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docPropertyType, boolean nullable) {
            super(jdbcType, docPropertyType, nullable);
            this.pgType = pgType;
        }

        @Override
        public void bind(DataBinder binder, Set value) throws SQLException {
            if (value == null) {
                this.bindNull(binder);
            } else {
                binder.setObject(PostgresHelper.asObject(this.pgType, this.formatValue(value)));
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, this.nullable ? null : "[]"));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<Set> {
        public Base(int dbType, DocPropertyType docPropertyType, boolean nullable) {
            super(Set.class, dbType, docPropertyType, nullable);
        }

        public Set read(DataReader reader) throws SQLException {
            String json = reader.getString();
            try {
                return EJson.parseSet((String)json, (boolean)true);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as Set", json, (Exception)e);
            }
        }

        public void bind(DataBinder binder, Set value) throws SQLException {
            if (value == null) {
                this.bindNull(binder);
            } else if (value.isEmpty()) {
                binder.setString("[]");
            } else {
                try {
                    binder.setString(EJson.write((Object)value));
                }
                catch (IOException e) {
                    throw new SQLException("Failed to format Set into JSON content", e);
                }
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            if (this.nullable) {
                binder.setNull(12);
            } else {
                binder.setString("[]");
            }
        }

        public String formatValue(Set value) {
            try {
                return EJson.write((Object)value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
            }
        }

        public Set parse(String value) {
            try {
                return this.convertList(EJson.parseList((String)value));
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as Set: [" + value + "]", (Throwable)e);
            }
        }

        public Set jsonRead(JsonParser parser) throws IOException {
            return this.convertList(EJson.parseList((JsonParser)parser, (JsonToken)parser.getCurrentToken()));
        }

        public void jsonWrite(JsonGenerator writer, Set value) throws IOException {
            EJson.write((Object)value, (JsonGenerator)writer);
        }

        private Set convertList(List list) {
            return new LinkedHashSet(list);
        }
    }

    private static class JsonB
    extends PgBase {
        public JsonB(DocPropertyType docPropertyType, boolean nullable) {
            super(5002, "jsonb", docPropertyType, nullable);
        }
    }

    private static class Json
    extends PgBase {
        public Json(DocPropertyType docPropertyType, boolean nullable) {
            super(5001, "json", docPropertyType, nullable);
        }
    }

    public static class Varchar
    extends Base {
        public Varchar(DocPropertyType docPropertyType, boolean nullable) {
            super(12, docPropertyType, nullable);
        }
    }
}

