/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ConvertInetAddresses;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeBaseVarchar;
import java.net.InetAddress;
import java.sql.SQLException;

public class ScalarTypeInetAddressPostgres
extends ScalarTypeBaseVarchar<InetAddress> {
    public ScalarTypeInetAddressPostgres() {
        super(InetAddress.class, false, 5020);
    }

    @Override
    public void bind(DataBinder binder, InetAddress value) throws SQLException {
        if (value == null) {
            binder.setNull(1111);
        } else {
            String strValue = this.convertToDbString(value);
            binder.setObject(PostgresHelper.asInet(strValue));
        }
    }

    @Override
    public InetAddress convertFromDbString(String dbValue) {
        try {
            return this.parse(dbValue);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error with InetAddresses [" + dbValue + "] " + e);
        }
    }

    @Override
    public String convertToDbString(InetAddress beanValue) {
        return this.formatValue(beanValue);
    }

    @Override
    public String formatValue(InetAddress v) {
        return ConvertInetAddresses.toHostAddress(v);
    }

    @Override
    public InetAddress parse(String value) {
        try {
            return ConvertInetAddresses.fromHost(value);
        }
        catch (IllegalArgumentException e) {
            throw new TextException("Error with InetAddresses [{}]", value, (Exception)e);
        }
    }
}

