/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.ScalarType;
import java.util.UUID;

interface ArrayElementConverter<T> {
    public static final ArrayElementConverter<UUID> UUID = new UuidConverter();
    public static final ArrayElementConverter<String> STRING = new StringConverter();
    public static final ArrayElementConverter<Long> LONG = new LongConverter();
    public static final ArrayElementConverter<Integer> INTEGER = new IntegerConverter();
    public static final ArrayElementConverter<Double> DOUBLE = new DoubleConverter();

    public T toElement(Object var1);

    default public Object[] toDbArray(Object[] objects) {
        return objects;
    }

    public static class EnumConverter
    implements ArrayElementConverter {
        private final ScalarType<?> scalarType;

        EnumConverter(ScalarType<?> scalarType) {
            this.scalarType = scalarType;
        }

        public Object toElement(Object rawValue) {
            return this.scalarType.toBeanType(rawValue);
        }

        @Override
        public Object[] toDbArray(Object[] objects) {
            Object[] dbArray = new Object[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                dbArray[i] = this.scalarType.toJdbcType(objects[i]);
            }
            return dbArray;
        }
    }

    public static class NoopConverter<T>
    implements ArrayElementConverter<T> {
        @Override
        public T toElement(Object rawValue) {
            return (T)rawValue;
        }
    }

    public static class UuidConverter
    extends NoopConverter<UUID> {
    }

    public static class StringConverter
    extends NoopConverter<String> {
    }

    public static class DoubleConverter
    implements ArrayElementConverter<Double> {
        @Override
        public Double toElement(Object rawValue) {
            if (rawValue instanceof Double) {
                return (Double)rawValue;
            }
            return ((Number)rawValue).doubleValue();
        }
    }

    public static class IntegerConverter
    implements ArrayElementConverter<Integer> {
        @Override
        public Integer toElement(Object rawValue) {
            if (rawValue instanceof Integer) {
                return (Integer)rawValue;
            }
            return ((Number)rawValue).intValue();
        }
    }

    public static class LongConverter
    implements ArrayElementConverter<Long> {
        @Override
        public Long toElement(Object rawValue) {
            if (rawValue instanceof Long) {
                return (Long)rawValue;
            }
            return ((Number)rawValue).longValue();
        }
    }
}

