/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.cache.QueryCacheEntry;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebeaninternal.server.transaction.RemoteTableMod;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModState
implements QueryCacheEntryValidate,
ServerCacheNotify {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.cache.TABLEMOD");
    private final Map<String, Long> tableModStamp = new ConcurrentHashMap<String, Long>();

    void touch(Set<String> touchedTables) {
        long modNanoTime = System.nanoTime();
        for (String tableName : touchedTables) {
            this.tableModStamp.put(tableName, modNanoTime);
        }
        if (log.isDebugEnabled()) {
            log.debug("TableModState updated - touched:{} modNanoTime:{}", touchedTables, (Object)modNanoTime);
        }
    }

    boolean isValid(Set<String> tables, long sinceNanoTime) {
        for (String tableName : tables) {
            Long modTime = this.tableModStamp.get(tableName);
            if (modTime == null || modTime < sinceNanoTime) continue;
            if (log.isTraceEnabled()) {
                log.trace("Invalidate on table:{}", (Object)tableName);
            }
            return false;
        }
        return true;
    }

    public boolean isValid(QueryCacheEntry entry) {
        Set dependentTables = entry.getDependentTables();
        if (dependentTables != null && !dependentTables.isEmpty()) {
            return this.isValid(dependentTables, entry.getTimestamp());
        }
        return true;
    }

    public void notify(ServerCacheNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug("ServerCacheNotification:{}", (Object)notification);
        }
        this.touch(notification.getDependentTables());
    }

    public void notify(RemoteTableMod tableMod) {
        if (log.isDebugEnabled()) {
            log.debug("RemoteTableMod:{}", (Object)tableMod);
        }
        this.touch(tableMod.getTables());
    }
}

