/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.RowConsumer;
import io.ebean.RowMapper;
import io.ebean.SqlRow;
import io.ebean.core.type.ScalarType;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetricMap;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.RelationalQueryEngine;
import io.ebeaninternal.server.core.RelationalQueryRequest;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.DefaultSqlRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.PersistenceException;

public class DefaultRelationalQueryEngine
implements RelationalQueryEngine {
    private final Binder binder;
    private final String dbTrueValue;
    private final boolean binaryOptimizedUUID;
    private final TimedMetricMap timedMetricMap;

    public DefaultRelationalQueryEngine(Binder binder, String dbTrueValue, boolean binaryOptimizedUUID) {
        this.binder = binder;
        this.dbTrueValue = dbTrueValue == null ? "true" : dbTrueValue;
        this.binaryOptimizedUUID = binaryOptimizedUUID;
        this.timedMetricMap = MetricFactory.get().createTimedMetricMap("sql.query.");
    }

    @Override
    public void collect(String label, long exeMicros) {
        this.timedMetricMap.add(label, exeMicros);
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.timedMetricMap.visit(visitor);
    }

    @Override
    public SqlRow createSqlRow(int estimateCapacity) {
        return new DefaultSqlRow(estimateCapacity, 0.75f, this.dbTrueValue, this.binaryOptimizedUUID);
    }

    private String errMsg(String msg, String sql) {
        return "Query threw SQLException:" + msg + " Query was:" + sql;
    }

    @Override
    public void findEach(RelationalQueryRequest request, Predicate<SqlRow> consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next() && consumer.test(this.readRow(request))) {
            }
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public void findEach(RelationalQueryRequest request, Consumer<SqlRow> consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next()) {
                consumer.accept(this.readRow(request));
            }
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> T findOneMapper(RelationalQueryRequest request, RowMapper<T> mapper) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.BEAN);
            T value = request.mapOne(mapper);
            request.logSummary();
            T t = value;
            return t;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> List<T> findListMapper(RelationalQueryRequest request, RowMapper<T> mapper) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            List<T> list = request.mapList(mapper);
            request.logSummary();
            List<T> list2 = list;
            return list2;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public void findEachRow(RelationalQueryRequest request, RowConsumer consumer) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            request.mapEach(consumer);
            request.logSummary();
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> List<T> findSingleAttributeList(RelationalQueryRequest request, Class<T> cls) {
        ScalarType<?> scalarType = this.binder.getScalarType(cls);
        return this.findScalarList(request, scalarType);
    }

    private <T> List<T> findScalarList(RelationalQueryRequest request, ScalarType<T> scalarType) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ATTRIBUTE);
            ArrayList<Object> list = new ArrayList<Object>();
            while (request.next()) {
                request.incrementRows();
                list.add(scalarType.read(this.binder.createDataReader(request.getResultSet())));
            }
            request.logSummary();
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public <T> T findSingleAttribute(RelationalQueryRequest request, Class<T> cls) {
        ScalarType<?> scalarType = this.binder.getScalarType(cls);
        return (T)this.findScalar(request, scalarType);
    }

    private <T> T findScalar(RelationalQueryRequest request, ScalarType<T> scalarType) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.ATTRIBUTE);
            Object value = null;
            if (request.next()) {
                request.incrementRows();
                value = scalarType.read(this.binder.createDataReader(request.getResultSet()));
            }
            request.logSummary();
            Object object = value;
            return (T)object;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public List<SqlRow> findList(RelationalQueryRequest request) {
        try {
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
            while (request.next()) {
                rows.add(this.readRow(request));
            }
            request.logSummary();
            ArrayList<SqlRow> arrayList = rows;
            return arrayList;
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    private SqlRow readRow(RelationalQueryRequest request) throws SQLException {
        return request.createNewRow();
    }
}

