/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.query.CQueryPlanManager;
import io.ebeaninternal.server.query.CQueryPlanRequest;
import io.ebeaninternal.server.type.bindcapture.BindCapture;
import java.util.concurrent.locks.ReentrantLock;

class CQueryBindCapture
implements SpiQueryBindCapture {
    private static final double multiplier = 1.3;
    private final ReentrantLock lock = new ReentrantLock();
    private final CQueryPlanManager manager;
    private final SpiQueryPlan queryPlan;
    private BindCapture bindCapture;
    private long queryTimeMicros;
    private long thresholdMicros;
    private long captureCount;
    private long lastBindCapture;

    CQueryBindCapture(CQueryPlanManager manager, SpiQueryPlan queryPlan, long thresholdMicros) {
        this.manager = manager;
        this.queryPlan = queryPlan;
        this.thresholdMicros = thresholdMicros;
    }

    @Override
    public boolean collectFor(long timeMicros) {
        return timeMicros > this.thresholdMicros && this.captureCount < 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBind(BindCapture bindCapture, long queryTimeMicros, long startNanos) {
        this.lock.lock();
        try {
            this.thresholdMicros = Math.round((double)queryTimeMicros * 1.3);
            ++this.captureCount;
            this.bindCapture = bindCapture;
            this.queryTimeMicros = queryTimeMicros;
            this.lastBindCapture = System.currentTimeMillis();
            this.manager.notifyBindCapture(this, startNanos);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void queryPlanInit(long thresholdMicros) {
        this.thresholdMicros = thresholdMicros;
        this.captureCount = 0L;
    }

    public boolean collectQueryPlan(CQueryPlanRequest request) {
        if (this.bindCapture == null || request.getSince() < this.lastBindCapture) {
            return false;
        }
        BindCapture last = this.bindCapture;
        SpiDbQueryPlan queryPlan = this.manager.collectPlan(request.getConnection(), this.queryPlan, last);
        if (queryPlan != null) {
            request.add(queryPlan.with(this.queryTimeMicros, this.captureCount));
            this.thresholdMicros = Long.MAX_VALUE;
            return true;
        }
        return false;
    }
}

