/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.ProfileLocation;
import io.ebeaninternal.server.util.Md5;

class DQueryPlanMeta {
    private final Class<?> type;
    private final String label;
    private final ProfileLocation profileLocation;
    private final String name;
    private final String sql;
    private final String hash;

    DQueryPlanMeta(Class<?> type, String label, ProfileLocation profileLocation, String sql) {
        this.type = type;
        this.label = label;
        this.profileLocation = profileLocation;
        this.sql = sql;
        String name = "dto." + type.getSimpleName();
        if (label != null) {
            name = name + "_" + label;
        }
        this.name = name;
        this.hash = this.initHash();
    }

    private String initHash() {
        StringBuilder sb = new StringBuilder(this.sql).append("|").append(this.name);
        if (this.profileLocation != null) {
            sb.append("|").append(this.profileLocation.location());
        }
        return Md5.hash(sb.toString());
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getHash() {
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    public String getLocation() {
        return this.profileLocation == null ? null : this.profileLocation.location();
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return this.name;
    }
}

