/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NamedParamHelp;
import io.ebeaninternal.server.expression.Op;
import java.io.IOException;

class BetweenExpression
extends AbstractExpression {
    private static final String _BETWEEN = " between ? and ?";
    private final Object valueHigh;
    private final Object valueLow;

    BetweenExpression(String propertyName, Object valueLow, Object valueHigh) {
        super(propertyName);
        this.valueLow = valueLow;
        this.valueHigh = valueHigh;
    }

    private Object low() {
        return NamedParamHelp.value(this.valueLow);
    }

    private Object high() {
        return NamedParamHelp.value(this.valueHigh);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeRange(this.propName, Op.GT_EQ, this.low(), Op.LT_EQ, this.high());
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.low());
        request.addBindValue(this.high());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(this.propName).append(_BETWEEN);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Between[").append(this.propName).append("]");
    }

    @Override
    public int queryBindHash() {
        int hc = this.low().hashCode();
        hc = hc * 92821 + this.high().hashCode();
        return hc;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        BetweenExpression that = (BetweenExpression)other;
        return this.low().equals(that.low()) && this.high().equals(that.high());
    }
}

