/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.ebeaninternal.server.executor.DaemonThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonScheduleThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DaemonScheduleThreadPool.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final String namePrefix;
    private final int shutdownWaitSeconds;

    public DaemonScheduleThreadPool(int coreSize, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, new DaemonThreadFactory(namePrefix));
        this.namePrefix = namePrefix;
        this.shutdownWaitSeconds = shutdownWaitSeconds;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (super.isShutdown()) {
                logger.debug("Already shutdown {}", (Object)this.namePrefix);
                return;
            }
            try {
                logger.trace("Shutting down {} ...", (Object)this.namePrefix);
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    logger.info("Shutdown wait timeout exceeded. Terminating running threads for {}", (Object)this.namePrefix);
                    super.shutdownNow();
                }
                logger.debug("Shutdown complete for {}", (Object)this.namePrefix);
            }
            catch (Exception e) {
                logger.error("Error during shutdown of " + this.namePrefix, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

