/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.Aggregation;
import io.ebean.annotation.CreatedTimestamp;
import io.ebean.annotation.DbArray;
import io.ebean.annotation.DbComment;
import io.ebean.annotation.DbDefault;
import io.ebean.annotation.DbJson;
import io.ebean.annotation.DbJsonB;
import io.ebean.annotation.DbMap;
import io.ebean.annotation.DbMigration;
import io.ebean.annotation.DocCode;
import io.ebean.annotation.DocEmbedded;
import io.ebean.annotation.DocProperty;
import io.ebean.annotation.DocSortable;
import io.ebean.annotation.Draft;
import io.ebean.annotation.DraftDirty;
import io.ebean.annotation.DraftOnly;
import io.ebean.annotation.DraftReset;
import io.ebean.annotation.Encrypted;
import io.ebean.annotation.Expose;
import io.ebean.annotation.Formula;
import io.ebean.annotation.HistoryExclude;
import io.ebean.annotation.Identity;
import io.ebean.annotation.Index;
import io.ebean.annotation.JsonIgnore;
import io.ebean.annotation.Length;
import io.ebean.annotation.SoftDelete;
import io.ebean.annotation.TenantId;
import io.ebean.annotation.UnmappedJson;
import io.ebean.annotation.UpdatedTimestamp;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;
import io.ebean.annotation.WhoCreated;
import io.ebean.annotation.WhoModified;
import io.ebean.config.EncryptDeploy;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.deploy.DbMigrationInfo;
import io.ebeaninternal.server.deploy.IndexDefinition;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.parse.AnnotationParser;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import io.ebeaninternal.server.type.DataEncryptSupport;
import io.ebeaninternal.server.type.ScalarTypeBytesBase;
import io.ebeaninternal.server.type.ScalarTypeBytesEncrypted;
import io.ebeaninternal.server.type.ScalarTypeEncryptedWrapper;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class AnnotationFields
extends AnnotationParser {
    private final boolean jacksonAnnotationsPresent;
    private final GeneratedPropertyFactory generatedPropFactory;
    private FetchType defaultLobFetchType = FetchType.LAZY;

    AnnotationFields(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig) {
        super(info, readConfig);
        this.jacksonAnnotationsPresent = readConfig.isJacksonAnnotations();
        this.generatedPropFactory = readConfig.getGeneratedPropFactory();
        if (readConfig.isEagerFetchLobs()) {
            this.defaultLobFetchType = FetchType.EAGER;
        }
    }

    @Override
    public void parse() {
        for (DeployBeanProperty prop : this.descriptor.propertiesAll()) {
            prop.initMetaAnnotations(this.readConfig.getMetaAnnotations());
            if (prop instanceof DeployBeanPropertyAssoc) {
                this.readAssocOne((DeployBeanPropertyAssoc)prop);
                continue;
            }
            this.readField(prop);
        }
    }

    private void readAssocOne(DeployBeanPropertyAssoc<?> prop) {
        Formula formula;
        DocEmbedded docEmbedded;
        this.readJsonAnnotations(prop);
        if (this.has(prop, Id.class)) {
            this.readIdAssocOne(prop);
        }
        if (this.has(prop, EmbeddedId.class)) {
            prop.setId();
            prop.setNullable(false);
            prop.setEmbedded();
            this.info.setEmbeddedId(prop);
        }
        if ((docEmbedded = this.get(prop, DocEmbedded.class)) != null) {
            prop.setDocStoreEmbedded(docEmbedded.doc());
            if (this.descriptor.isDocStoreOnly() && this.has(prop, ManyToOne.class)) {
                prop.setEmbedded();
                prop.setDbInsertable(true);
                prop.setDbUpdateable(true);
            }
        }
        if (prop instanceof DeployBeanPropertyAssocOne) {
            if (prop.isId() && !prop.isEmbedded()) {
                prop.setEmbedded();
            }
            this.readEmbeddedAttributeOverrides((DeployBeanPropertyAssocOne)prop);
        }
        if ((formula = prop.getMetaAnnotationFormula(this.platform)) != null) {
            prop.setSqlFormula(formula.select(), formula.join());
        }
        this.initWhoProperties(prop);
        this.initDbMigration(prop);
    }

    private void initWhoProperties(DeployBeanProperty prop) {
        if (this.has(prop, WhoModified.class)) {
            this.generatedPropFactory.setWhoModified(prop);
        }
        if (this.has(prop, WhoCreated.class)) {
            this.generatedPropFactory.setWhoCreated(prop);
        }
    }

    private void readField(DeployBeanProperty prop) {
        boolean isEnum = prop.getPropertyType().isEnum();
        Enumerated enumerated = this.get(prop, Enumerated.class);
        if (isEnum || enumerated != null) {
            this.util.setEnumScalarType(enumerated, prop);
        }
        prop.setDbRead(true);
        prop.setDbInsertable(true);
        prop.setDbUpdateable(true);
        Column column = prop.getMetaAnnotation(Column.class);
        if (column != null) {
            this.readColumn(column, prop);
        }
        this.readJsonAnnotations(prop);
        if (prop.getDbColumn() == null) {
            prop.setDbColumn(this.namingConvention.getColumnFromProperty(this.beanType, prop.getName()));
        }
        this.initIdentity(prop);
        this.initTenantId(prop);
        this.initDbJson(prop);
        this.initFormula(prop);
        this.initVersion(prop);
        this.initWhen(prop);
        this.initWhoProperties(prop);
        this.initDbMigration(prop);
        if (this.has(prop, Transient.class)) {
            prop.setDbRead(false);
            prop.setDbInsertable(false);
            prop.setDbUpdateable(false);
            prop.setTransient();
        }
        this.initEncrypt(prop);
        for (Index index : this.annotationIndexes(prop)) {
            this.addIndex(prop, index);
        }
    }

    private void initIdentity(DeployBeanProperty prop) {
        Temporal temporal;
        Identity identity;
        Id id = this.get(prop, Id.class);
        GeneratedValue gen = this.get(prop, GeneratedValue.class);
        if (gen != null) {
            this.readGenValue(gen, id, prop);
        }
        if (id != null) {
            this.readIdScalar(prop);
        }
        if ((identity = this.get(prop, Identity.class)) != null) {
            this.readIdentity(identity);
        }
        if ((temporal = this.get(prop, Temporal.class)) != null) {
            this.readTemporal(temporal, prop);
        } else if (this.has(prop, Lob.class)) {
            this.util.setLobType(prop);
        }
        Length length = this.get(prop, Length.class);
        if (length != null) {
            prop.setDbLength(length.value());
        }
        if (this.has(prop, io.ebean.annotation.NotNull.class)) {
            prop.setNullable(false);
        }
    }

    private void initValidation(DeployBeanProperty prop) {
        NotNull notNull = this.get(prop, NotNull.class);
        if (notNull != null && this.isEbeanValidationGroups(notNull.groups())) {
            prop.setNullable(false);
        }
        if (!prop.isLob()) {
            int maxSize = -1;
            for (Size size : prop.getMetaAnnotationSize()) {
                if (size.max() >= Integer.MAX_VALUE) continue;
                maxSize = Math.max(maxSize, size.max());
            }
            if (maxSize != -1) {
                prop.setDbLength(maxSize);
            }
        }
    }

    private void initTenantId(DeployBeanProperty prop) {
        if (this.validationAnnotations) {
            this.initValidation(prop);
        }
        if (this.has(prop, TenantId.class)) {
            prop.setTenantId();
        }
        if (this.has(prop, Draft.class)) {
            prop.setDraft();
        }
        if (this.has(prop, DraftOnly.class)) {
            prop.setDraftOnly();
        }
        if (this.has(prop, DraftDirty.class)) {
            prop.setDraftDirty();
        }
        if (this.has(prop, DraftReset.class)) {
            prop.setDraftReset();
        }
        if (this.has(prop, SoftDelete.class)) {
            prop.setSoftDelete();
        }
    }

    private void initDbJson(DeployBeanProperty prop) {
        DbJson dbJson;
        DbMap dbMap;
        DbComment comment = this.get(prop, DbComment.class);
        if (comment != null) {
            prop.setDbComment(comment.value());
        }
        if ((dbMap = this.get(prop, DbMap.class)) != null) {
            this.util.setDbMap(prop, dbMap);
            this.setColumnName(prop, dbMap.name());
        }
        if ((dbJson = this.get(prop, DbJson.class)) != null) {
            this.util.setDbJsonType(prop, dbJson);
            this.setColumnName(prop, dbJson.name());
        } else {
            DbJsonB dbJsonB = this.get(prop, DbJsonB.class);
            if (dbJsonB != null) {
                this.util.setDbJsonBType(prop, dbJsonB);
                this.setColumnName(prop, dbJsonB.name());
            }
        }
        DbArray dbArray = this.get(prop, DbArray.class);
        if (dbArray != null) {
            this.util.setDbArray(prop, dbArray);
            this.setColumnName(prop, dbArray.name());
        }
    }

    private void initFormula(DeployBeanProperty prop) {
        Aggregation aggregation;
        Formula formula;
        DocProperty docProperty;
        DocSortable docSortable;
        DocCode docCode = this.get(prop, DocCode.class);
        if (docCode != null) {
            prop.setDocCode(docCode);
        }
        if ((docSortable = this.get(prop, DocSortable.class)) != null) {
            prop.setDocSortable(docSortable);
        }
        if ((docProperty = this.get(prop, DocProperty.class)) != null) {
            prop.setDocProperty(docProperty);
        }
        if ((formula = prop.getMetaAnnotationFormula(this.platform)) != null) {
            prop.setSqlFormula(formula.select(), formula.join());
        }
        if ((aggregation = prop.getMetaAnnotation(Aggregation.class)) != null) {
            prop.setAggregation(aggregation.value().replace("$1", prop.getName()));
        }
    }

    private void initVersion(DeployBeanProperty prop) {
        Basic basic;
        if (this.has(prop, Version.class)) {
            prop.setVersionColumn();
            this.generatedPropFactory.setVersion(prop);
        }
        if ((basic = this.get(prop, Basic.class)) != null) {
            prop.setFetchType(basic.fetch());
            if (!basic.optional()) {
                prop.setNullable(false);
            }
        } else if (prop.isLob()) {
            prop.setFetchType(this.defaultLobFetchType);
        }
    }

    private void initWhen(DeployBeanProperty prop) {
        if (this.has(prop, WhenCreated.class) || this.has(prop, CreatedTimestamp.class)) {
            this.generatedPropFactory.setInsertTimestamp(prop);
        }
        if (this.has(prop, WhenModified.class) || this.has(prop, UpdatedTimestamp.class)) {
            this.generatedPropFactory.setUpdateTimestamp(prop);
        }
    }

    private void initEncrypt(DeployBeanProperty prop) {
        if (!prop.isTransient()) {
            EncryptDeploy encryptDeploy = this.util.getEncryptDeploy(this.info.getDescriptor().getBaseTableFull(), prop.getDbColumn());
            if (encryptDeploy == null || encryptDeploy.getMode() == EncryptDeploy.Mode.MODE_ANNOTATION) {
                Encrypted encrypted = this.get(prop, Encrypted.class);
                if (encrypted != null) {
                    this.setEncryption(prop, encrypted.dbEncryption(), encrypted.dbLength());
                }
            } else if (EncryptDeploy.Mode.MODE_ENCRYPT == encryptDeploy.getMode()) {
                this.setEncryption(prop, encryptDeploy.isDbEncrypt(), encryptDeploy.getDbLength());
            }
        }
    }

    private void readIdentity(Identity identity) {
        this.descriptor.setIdentityMode(identity);
    }

    private void initDbMigration(DeployBeanProperty prop) {
        DbDefault dbDefault;
        if (this.has(prop, HistoryExclude.class)) {
            prop.setExcludedFromHistory();
        }
        if ((dbDefault = this.get(prop, DbDefault.class)) != null) {
            prop.setDbColumnDefault(dbDefault.value());
        }
        Set<DbMigration> dbMigration = this.annotationDbMigrations(prop);
        dbMigration.forEach(ann -> prop.addDbMigrationInfo(new DbMigrationInfo(ann.preAdd(), ann.postAdd(), ann.preAlter(), ann.postAlter(), ann.platforms())));
    }

    private void addIndex(DeployBeanProperty prop, Index index) {
        String[] columnNames;
        if (index.columnNames().length == 0) {
            columnNames = new String[]{prop.getDbColumn()};
        } else {
            columnNames = new String[index.columnNames().length];
            int i = 0;
            int found = 0;
            for (String colName : index.columnNames()) {
                if (colName.equals("${fa}") || colName.equals(prop.getDbColumn())) {
                    columnNames[i++] = prop.getDbColumn();
                    ++found;
                    continue;
                }
                columnNames[i++] = colName;
            }
            if (found != 1) {
                throw new RuntimeException("DB-columname has to be specified exactly one time in columnNames.");
            }
        }
        if (columnNames.length == 1 && this.hasRelationshipItem(prop)) {
            throw new RuntimeException("Can't use Index on foreign key relationships.");
        }
        this.descriptor.addIndex(new IndexDefinition(columnNames, index.name(), index.unique(), index.platforms(), index.concurrent(), index.definition()));
    }

    private void readJsonAnnotations(DeployBeanProperty prop) {
        JsonIgnore jsonIgnore;
        Expose expose;
        com.fasterxml.jackson.annotation.JsonIgnore jsonIgnore2;
        if (this.jacksonAnnotationsPresent && (jsonIgnore2 = this.get(prop, com.fasterxml.jackson.annotation.JsonIgnore.class)) != null) {
            prop.setJsonSerialize(!jsonIgnore2.value());
            prop.setJsonDeserialize(!jsonIgnore2.value());
        }
        if ((expose = this.get(prop, Expose.class)) != null) {
            prop.setJsonSerialize(expose.serialize());
            prop.setJsonDeserialize(expose.deserialize());
        }
        if ((jsonIgnore = this.get(prop, JsonIgnore.class)) != null) {
            prop.setJsonSerialize(jsonIgnore.serialize());
            prop.setJsonDeserialize(jsonIgnore.deserialize());
        }
        if (this.has(prop, UnmappedJson.class)) {
            prop.setUnmappedJson();
        }
    }

    private boolean hasRelationshipItem(DeployBeanProperty prop) {
        return this.has(prop, OneToMany.class) || this.has(prop, ManyToOne.class) || this.has(prop, OneToOne.class);
    }

    private void setEncryption(DeployBeanProperty prop, boolean dbEncString, int dbLen) {
        int jdbcType;
        DbEncryptFunction dbEncryptFunction;
        DbEncrypt dbEncrypt;
        this.util.checkEncryptKeyManagerDefined(prop.getFullBeanName());
        ScalarType<?> st = prop.getScalarType();
        if (byte[].class.equals((Object)st.getType())) {
            ScalarTypeBytesBase baseType = (ScalarTypeBytesBase)st;
            DataEncryptSupport support = this.createDataEncryptSupport(prop);
            ScalarTypeBytesEncrypted encryptedScalarType = new ScalarTypeBytesEncrypted(baseType, support);
            prop.setScalarType(encryptedScalarType);
            prop.setLocalEncrypted();
            return;
        }
        if (dbEncString && (dbEncrypt = this.util.getDbPlatform().getDbEncrypt()) != null && (dbEncryptFunction = dbEncrypt.getDbEncryptFunction(jdbcType = prop.getScalarType().getJdbcType())) != null) {
            prop.setDbEncryptFunction(dbEncryptFunction, dbEncrypt, dbLen);
            return;
        }
        prop.setScalarType(this.createScalarType(prop, st));
        prop.setLocalEncrypted();
        if (dbLen > 0) {
            prop.setDbLength(dbLen);
        }
    }

    private ScalarTypeEncryptedWrapper<?> createScalarType(DeployBeanProperty prop, ScalarType<?> st) {
        DataEncryptSupport support = this.createDataEncryptSupport(prop);
        ScalarTypeBytesBase byteType = this.getDbEncryptType(prop);
        return new ScalarTypeEncryptedWrapper(st, byteType, support);
    }

    private ScalarTypeBytesBase getDbEncryptType(DeployBeanProperty prop) {
        int dbType = prop.isLob() ? 2004 : -3;
        return (ScalarTypeBytesBase)this.util.getTypeManager().getScalarType(dbType);
    }

    private DataEncryptSupport createDataEncryptSupport(DeployBeanProperty prop) {
        String table = this.info.getDescriptor().getBaseTable();
        String column = prop.getDbColumn();
        return this.util.createDataEncryptSupport(table, column);
    }

    private void readGenValue(GeneratedValue gen, Id id, DeployBeanProperty prop) {
        GenerationType strategy;
        if (id == null && UUID.class.equals(prop.getPropertyType())) {
            this.generatedPropFactory.setUuid(prop);
            return;
        }
        this.descriptor.setIdGeneratedValue();
        SequenceGenerator seq = this.get(prop, SequenceGenerator.class);
        if (seq != null) {
            String seqName = seq.sequenceName();
            if (seqName.isEmpty()) {
                seqName = this.namingConvention.getSequenceName(this.descriptor.getBaseTable(), prop.getDbColumn());
            }
            this.descriptor.setIdentitySequence(seq.initialValue(), seq.allocationSize(), seqName);
        }
        if ((strategy = gen.strategy()) == GenerationType.IDENTITY) {
            this.descriptor.setIdentityType(IdType.IDENTITY);
        } else if (strategy == GenerationType.SEQUENCE) {
            this.descriptor.setIdentityType(IdType.SEQUENCE);
            if (!gen.generator().isEmpty()) {
                this.descriptor.setIdentitySequenceGenerator(gen.generator());
            }
        } else if (strategy == GenerationType.AUTO) {
            if (!gen.generator().isEmpty()) {
                PlatformIdGenerator idGenerator = this.generatedPropFactory.getIdGenerator(gen.generator());
                if (idGenerator == null) {
                    throw new IllegalStateException("No custom IdGenerator registered with name " + gen.generator());
                }
                this.descriptor.setCustomIdGenerator(idGenerator);
            } else if (prop.getPropertyType().equals(UUID.class)) {
                this.descriptor.setUuidGenerator();
            }
        }
    }

    private void readTemporal(Temporal temporal, DeployBeanProperty prop) {
        TemporalType type = temporal.value();
        if (type == TemporalType.DATE) {
            prop.setDbType(91);
        } else if (type == TemporalType.TIMESTAMP) {
            prop.setDbType(93);
        } else if (type == TemporalType.TIME) {
            prop.setDbType(92);
        } else {
            throw new PersistenceException("Unhandled type " + type);
        }
    }
}

