/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.DbMigration;
import io.ebean.annotation.Index;
import io.ebean.annotation.Indices;
import io.ebean.annotation.Platform;
import io.ebean.config.NamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.parse.AnnotationFind;
import io.ebeaninternal.server.deploy.parse.DeployUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

abstract class AnnotationBase {
    final DatabasePlatform databasePlatform;
    protected final Platform platform;
    final NamingConvention namingConvention;
    final DeployUtil util;

    AnnotationBase(DeployUtil util) {
        this.util = util;
        this.databasePlatform = util.getDbPlatform();
        this.platform = this.databasePlatform.getPlatform();
        this.namingConvention = util.getNamingConvention();
    }

    public abstract void parse();

    boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    <T extends Annotation> T get(DeployBeanProperty prop, Class<T> annClass) {
        return (T)AnnotationUtil.get((AnnotatedElement)prop.getField(), annClass);
    }

    <T extends Annotation> boolean has(DeployBeanProperty prop, Class<T> annClass) {
        return AnnotationUtil.has((AnnotatedElement)prop.getField(), annClass);
    }

    Set<JoinColumn> annotationJoinColumns(DeployBeanProperty prop) {
        return AnnotationFind.joinColumns(prop.getField());
    }

    Set<AttributeOverride> annotationAttributeOverrides(DeployBeanProperty prop) {
        return AnnotationFind.attributeOverrides(prop.getField());
    }

    Set<Index> annotationIndexes(DeployBeanProperty prop) {
        return AnnotationFind.indexes(prop.getField());
    }

    Set<DbMigration> annotationDbMigrations(DeployBeanProperty prop) {
        return AnnotationFind.dbMigrations(prop.getField());
    }

    Set<Index> annotationClassIndexes(Class<?> cls) {
        Set result = AnnotationUtil.typeGetAll(cls, Index.class);
        for (Indices index : AnnotationUtil.typeGetAll(cls, Indices.class)) {
            Collections.addAll(result, index.value());
        }
        return result;
    }

    Set<NamedQuery> annotationClassNamedQuery(Class<?> cls) {
        Set result = AnnotationUtil.typeGetAll(cls, NamedQuery.class);
        for (NamedQueries queries : AnnotationUtil.typeGetAll(cls, NamedQueries.class)) {
            Collections.addAll(result, queries.value());
        }
        return result;
    }
}

