/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.id;

import io.ebean.bean.EntityBean;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.type.DataBind;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IdBinderEmbedded
implements IdBinder {
    private final BeanPropertyAssocOne<?> embIdProperty;
    private final boolean idInExpandedForm;
    private BeanProperty[] props;
    private BeanDescriptor<?> idDesc;
    private String idInValueSql;

    public IdBinderEmbedded(boolean idInExpandedForm, BeanPropertyAssocOne<?> embIdProperty) {
        this.idInExpandedForm = idInExpandedForm;
        this.embIdProperty = embIdProperty;
    }

    @Override
    public void initialise() {
        this.idDesc = this.embIdProperty.getTargetDescriptor();
        this.props = this.embIdProperty.getProperties();
        this.idInValueSql = this.idInExpandedForm ? this.idInExpanded() : this.idInCompressed();
    }

    @Override
    public boolean isIdInExpandedForm() {
        return this.idInExpandedForm;
    }

    private String idInExpanded() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(this.idDesc.getBaseTableAlias());
            sb.append(".");
            sb.append(this.props[i].getDbColumn());
            sb.append("=?");
        }
        sb.append(")");
        return sb.toString();
    }

    private String idInCompressed() {
        StringBuilder sb = new StringBuilder(20).append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public BeanProperty getBeanProperty() {
        return this.embIdProperty;
    }

    @Override
    public String getOrderBy(String pathPrefix, boolean ascending) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (pathPrefix != null) {
                sb.append(pathPrefix).append(".");
            }
            sb.append(this.embIdProperty.getName()).append(".");
            sb.append(this.props[i].getName());
            if (ascending) continue;
            sb.append(" desc");
        }
        return sb.toString();
    }

    public BeanDescriptor<?> getIdBeanDescriptor() {
        return this.idDesc;
    }

    @Override
    public String getIdProperty() {
        return this.embIdProperty.getName();
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        prefix = SplitName.add((String)prefix, (String)this.embIdProperty.getName());
        for (BeanProperty prop : this.props) {
            prop.buildRawSqlSelectChain(prefix, selectChain);
        }
    }

    @Override
    public BeanProperty findBeanProperty(String dbColumnName) {
        for (BeanProperty prop : this.props) {
            if (!dbColumnName.equalsIgnoreCase(prop.getDbColumn())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean isComplexId() {
        return true;
    }

    @Override
    public String getDefaultOrderBy() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.embIdProperty.getName());
            sb.append(".");
            sb.append(this.props[i].getName());
        }
        return sb.toString();
    }

    public BeanProperty[] getProperties() {
        return this.props;
    }

    @Override
    public String getIdInValueExprDelete(int size) {
        if (size <= 0) {
            throw new IndexOutOfBoundsException("The size must be at least 1");
        }
        if (!this.idInExpandedForm) {
            return this.getIdInValueExpr(false, size);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int j = 0; j < size; ++j) {
            if (j > 0) {
                sb.append(" or ");
            }
            sb.append("(");
            for (int i = 0; i < this.props.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(this.props[i].getDbColumn());
                sb.append("=?");
            }
            sb.append(")");
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public String getIdInValueExpr(boolean not, int size) {
        if (size <= 0) {
            throw new IndexOutOfBoundsException("The size must be at least 1");
        }
        StringBuilder sb = new StringBuilder();
        if (not) {
            sb.append(" not");
        }
        if (!this.idInExpandedForm) {
            sb.append(" in");
        }
        sb.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                if (this.idInExpandedForm) {
                    sb.append(" or ");
                } else {
                    sb.append(",");
                }
            }
            sb.append(this.idInValueSql);
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public Object[] getIdValues(EntityBean bean) {
        Object val = this.embIdProperty.getValue(bean);
        Object[] bindvalues = new Object[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            bindvalues[i] = this.props[i].getValue((EntityBean)val);
        }
        return bindvalues;
    }

    @Override
    public Object[] getBindValues(Object value) {
        Object[] bindValues = new Object[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            bindValues[i] = this.props[i].getValue((EntityBean)value);
        }
        return bindValues;
    }

    @Override
    public Object getIdForJson(EntityBean bean) {
        EntityBean ebValue = (EntityBean)this.embIdProperty.getValue(bean);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (BeanProperty prop : this.props) {
            map.put(prop.getName(), prop.getValue(ebValue));
        }
        return map;
    }

    @Override
    public Object convertIdFromJson(Object value) {
        Map map = (Map)value;
        EntityBean idValue = this.idDesc.createEntityBean();
        for (BeanProperty prop : this.props) {
            prop.setValue(idValue, map.get(prop.getName()));
        }
        return idValue;
    }

    @Override
    public void bindId(DefaultSqlUpdate sqlUpdate, Object value) {
        for (BeanProperty prop : this.props) {
            Object embFieldValue = prop.getValue((EntityBean)value);
            sqlUpdate.setParameter(embFieldValue);
        }
    }

    @Override
    public void bindId(DataBind dataBind, Object value) throws SQLException {
        for (BeanProperty prop : this.props) {
            Object embFieldValue = prop.getValue((EntityBean)value);
            prop.bind(dataBind, embFieldValue);
        }
    }

    @Override
    public void addIdInBindValues(DefaultSqlUpdate sqlUpdate, Collection<?> values) {
        for (Object value : values) {
            this.bindId(sqlUpdate, value);
        }
    }

    @Override
    public void addIdInBindValues(SpiExpressionRequest request, Collection<?> values) {
        for (Object value : values) {
            for (BeanProperty prop : this.props) {
                request.addBindValue(prop.getValue((EntityBean)value));
            }
        }
    }

    @Override
    public Object readData(DataInput dataInput) throws IOException {
        EntityBean embId = this.idDesc.createEntityBean();
        boolean notNull = true;
        for (BeanProperty prop : this.props) {
            Object value = prop.readData(dataInput);
            prop.setValue(embId, value);
            if (value != null) continue;
            notNull = false;
        }
        return notNull ? embId : null;
    }

    @Override
    public void writeData(DataOutput dataOutput, Object idValue) throws IOException {
        for (BeanProperty prop : this.props) {
            Object embFieldValue = prop.getValue((EntityBean)idValue);
            prop.writeData(dataOutput, embFieldValue);
        }
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        for (BeanProperty prop : this.props) {
            prop.loadIgnore(ctx);
        }
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        EntityBean embId = this.idDesc.createEntityBean();
        boolean nullValue = true;
        for (BeanProperty prop : this.props) {
            Object value = prop.read(ctx);
            if (value == null) continue;
            prop.setValue(embId, value);
            nullValue = false;
        }
        return nullValue ? null : embId;
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        Object embId = this.read(ctx);
        if (embId != null) {
            this.embIdProperty.setValue(bean, embId);
            return embId;
        }
        return null;
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        for (BeanProperty prop : this.props) {
            prop.appendSelect(ctx, subQuery);
        }
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(".");
            }
            sb.append(this.props[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getAssocOneIdExpr(String prefix, String operator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(".");
            }
            sb.append(this.embIdProperty.getName());
            sb.append(".");
            sb.append(this.props[i].getName());
            sb.append(operator);
        }
        return sb.toString();
    }

    @Override
    public String getBindIdSql(String baseTableAlias) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (baseTableAlias != null) {
                sb.append(baseTableAlias);
                sb.append(".");
            }
            sb.append(this.props[i].getDbColumn());
            sb.append(" = ? ");
        }
        return sb.toString();
    }

    @Override
    public String getBindIdInSql(String baseTableAlias) {
        if (this.idInExpandedForm) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (baseTableAlias != null) {
                sb.append(baseTableAlias);
                sb.append(".");
            }
            sb.append(this.props[i].getDbColumn());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object convertId(Object idValue) {
        if (idValue instanceof String) {
            EntityBean embId = this.idDesc.createEntityBean();
            String[] rawVals = ((String)idValue).split("\\|");
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i].setValue(embId, this.props[i].parse(rawVals[i]));
            }
            return embId;
        }
        return idValue;
    }

    @Override
    public Object convertSetId(Object idValue, EntityBean bean) {
        if (bean != null) {
            this.embIdProperty.setValueIntercept(bean, idValue);
        }
        return idValue;
    }

    @Override
    public String cacheKey(Object value) {
        EntityBean bean = (EntityBean)value;
        StringBuilder sb = new StringBuilder();
        for (BeanProperty prop : this.props) {
            Object val = prop.getValue(bean);
            if (val != null) {
                sb.append(prop.format(val));
            }
            sb.append("|");
        }
        return sb.toString();
    }

    @Override
    public String cacheKeyFromBean(EntityBean bean) {
        return this.cacheKey(this.embIdProperty.getValue(bean));
    }
}

