/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.BeanQueryRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ChainedBeanQueryAdapter
implements BeanQueryAdapter {
    private static final Sorter SORTER = new Sorter();
    private final List<BeanQueryAdapter> list;
    private final BeanQueryAdapter[] chain;

    public ChainedBeanQueryAdapter(List<BeanQueryAdapter> list) {
        this.list = list;
        BeanQueryAdapter[] c = list.toArray(new BeanQueryAdapter[0]);
        Arrays.sort(c, SORTER);
        this.chain = c;
    }

    public ChainedBeanQueryAdapter register(BeanQueryAdapter c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanQueryAdapter> newList = new ArrayList<BeanQueryAdapter>(this.list);
        newList.add(c);
        return new ChainedBeanQueryAdapter(newList);
    }

    public ChainedBeanQueryAdapter deregister(BeanQueryAdapter c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanQueryAdapter> newList = new ArrayList<BeanQueryAdapter>(this.list);
        newList.remove(c);
        return new ChainedBeanQueryAdapter(newList);
    }

    public int getExecutionOrder() {
        return 0;
    }

    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    public void preQuery(BeanQueryRequest<?> request) {
        for (BeanQueryAdapter aChain : this.chain) {
            aChain.preQuery(request);
        }
    }

    private static class Sorter
    implements Comparator<BeanQueryAdapter> {
        private Sorter() {
        }

        @Override
        public int compare(BeanQueryAdapter o1, BeanQueryAdapter o2) {
            return Integer.compare(o1.getExecutionOrder(), o2.getExecutionOrder());
        }
    }
}

