/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.server.dto.DtoNamedQueries;
import io.ebeaninternal.xmapping.api.XmapDto;
import io.ebeaninternal.xmapping.api.XmapEbean;
import io.ebeaninternal.xmapping.api.XmapRawSql;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalConfigXmlMap {
    private static final Logger log = LoggerFactory.getLogger(InternalConfigXmlMap.class);
    private final List<XmapEbean> xmlEbeanList;
    private final ClassLoader classLoader;
    private final Map<Class<?>, DtoNamedQueries> dtoNamedQueries = new HashMap();

    InternalConfigXmlMap(List<XmapEbean> xmlEbeanList, ClassLoader classLoader) {
        this.xmlEbeanList = xmlEbeanList;
        this.classLoader = classLoader;
        this.initDtoMapping();
    }

    void initDtoMapping() {
        if (this.xmlEbeanList != null) {
            for (XmapEbean mapping : this.xmlEbeanList) {
                List dtoList = mapping.getDto();
                for (XmapDto dto : dtoList) {
                    this.readDtoMapping(dto);
                }
            }
        }
    }

    List<XmapEbean> xmlDeployment() {
        return this.xmlEbeanList;
    }

    Map<Class<?>, DtoNamedQueries> readDtoMapping() {
        return this.dtoNamedQueries;
    }

    private void readDtoMapping(XmapDto dto) {
        Class<?> dtoClass;
        try {
            dtoClass = Class.forName(dto.getClazz(), false, this.classLoader);
        }
        catch (Exception e) {
            log.error("Could not load dto bean class " + dto.getClazz() + " for ebean xml entry");
            return;
        }
        DtoNamedQueries namedQueries = this.dtoNamedQueries.computeIfAbsent(dtoClass, aClass -> new DtoNamedQueries());
        for (XmapRawSql sql : dto.getRawSql()) {
            namedQueries.addRawSql(sql.getName(), sql.getQuery());
        }
    }
}

