/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.core.type.DataReader;
import io.ebeaninternal.api.SpiDtoQuery;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.AbstractSqlQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.dto.DtoColumn;
import io.ebeaninternal.server.dto.DtoMappingRequest;
import io.ebeaninternal.server.dto.DtoQueryPlan;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.DtoQueryEngine;
import io.ebeaninternal.server.type.RsetDataReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class DtoQueryRequest<T>
extends AbstractSqlQueryRequest {
    private final SpiDtoQuery<T> query;
    private final DtoQueryEngine queryEngine;
    private DtoQueryPlan plan;
    private DataReader dataReader;

    DtoQueryRequest(SpiEbeanServer server, DtoQueryEngine engine, SpiDtoQuery<T> query) {
        super(server, query, query.getTransaction());
        this.queryEngine = engine;
        this.query = query;
        query.obtainLocation();
    }

    @Override
    public void executeSql(Binder binder, SpiQuery.Type type) throws SQLException {
        this.startNano = System.nanoTime();
        SpiQuery<?> ormQuery = this.query.getOrmQuery();
        if (ormQuery != null) {
            ormQuery.setType(type);
            ormQuery.setManualId();
            SpiResultSet result = this.server.findResultSet(ormQuery, this.transaction);
            this.pstmt = result.getStatement();
            this.sql = ormQuery.getGeneratedSql();
            this.setResultSet(result.getResultSet(), ormQuery.getQueryPlanKey());
        } else {
            this.executeAsSql(binder);
        }
    }

    @Override
    protected void setResultSet(ResultSet resultSet, Object queryPlanKey) throws SQLException {
        this.resultSet = resultSet;
        this.dataReader = new RsetDataReader(this.server.getDataTimeZone(), resultSet);
        this.obtainPlan(queryPlanKey);
    }

    private void obtainPlan(Object planKey) throws SQLException {
        if (planKey == null) {
            planKey = this.query.planKey();
        }
        this.plan = this.query.getQueryPlan(planKey);
        if (this.plan == null) {
            this.plan = this.query.buildPlan(this.mappingRequest());
            this.query.putQueryPlan(planKey, this.plan);
        }
    }

    @Override
    protected void requestComplete() {
        if (this.plan != null) {
            long exeMicros = (System.nanoTime() - this.startNano) / 1000L;
            this.plan.collect(exeMicros);
        }
    }

    public void findEach(Consumer<T> consumer) {
        this.flushJdbcBatchOnQuery();
        this.queryEngine.findEach(this, consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.flushJdbcBatchOnQuery();
        this.queryEngine.findEachWhile(this, consumer);
    }

    public List<T> findList() {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findList(this);
    }

    public T readNextBean() throws SQLException {
        this.dataReader.resetColumnPosition();
        return (T)this.plan.readRow(this.dataReader);
    }

    private DtoMappingRequest mappingRequest() throws SQLException {
        return new DtoMappingRequest(this.query, this.sql, this.readMeta());
    }

    private DtoColumn[] readMeta() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int cols = metaData.getColumnCount();
        DtoColumn[] meta = new DtoColumn[cols];
        for (int i = 0; i < cols; ++i) {
            int pos = i + 1;
            String columnLabel = metaData.getColumnLabel(pos);
            if (columnLabel == null) {
                columnLabel = metaData.getColumnName(pos);
            }
            meta[i] = new DtoColumn(DtoQueryRequest.parseColumn(columnLabel));
        }
        return meta;
    }

    static String parseColumn(String columnLabel) {
        int pos;
        if ((columnLabel.startsWith("_e_") || columnLabel.startsWith("_E_")) && (pos = columnLabel.indexOf("_", 3)) > -1) {
            return columnLabel.substring(pos + 1);
        }
        return columnLabel;
    }
}

