/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.json;

import io.ebean.ModifyAwareType;
import io.ebeaninternal.json.ModifyAwareFlag;
import io.ebeaninternal.json.ModifyAwareIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class ModifyAwareSet<E>
implements Set<E>,
ModifyAwareType,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ModifyAwareType owner;
    protected final Set<E> set;

    public ModifyAwareSet(Set<E> underlying) {
        this(new ModifyAwareFlag(), underlying);
    }

    public ModifyAwareSet(ModifyAwareType owner, Set<E> underlying) {
        this.owner = owner;
        this.set = underlying;
    }

    public boolean isMarkedDirty() {
        return this.owner.isMarkedDirty();
    }

    public void setMarkedDirty(boolean markedDirty) {
        this.owner.setMarkedDirty(markedDirty);
    }

    private void markAsDirty() {
        this.owner.setMarkedDirty(true);
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModifyAwareSet) {
            ModifyAwareSet that = (ModifyAwareSet)o;
            return Objects.equals(this.set, that.set);
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set that = (Set)o;
        return Objects.equals(this.set, that);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean add(E o) {
        if (this.set.add(o)) {
            this.markAsDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E o : collection) {
            if (!this.set.add(o)) continue;
            this.markAsDirty();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (!this.set.isEmpty()) {
            this.markAsDirty();
        }
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new ModifyAwareIterator<E>(this.owner, this.set.iterator());
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.markAsDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            if (!this.set.remove(element)) continue;
            this.markAsDirty();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<E> it = this.set.iterator();
        while (it.hasNext()) {
            E o = it.next();
            if (collection.contains(o)) continue;
            it.remove();
            this.markAsDirty();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }
}

