/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.service.SpiJsonService;
import io.ebeaninternal.json.EJsonReader;
import io.ebeaninternal.json.EJsonWriter;
import io.ebeaninternal.json.ModifyAwareList;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DJsonService
implements SpiJsonService {
    public String write(Object object) throws IOException {
        return EJsonWriter.write(object);
    }

    public void write(Object object, Writer writer) throws IOException {
        EJsonWriter.write(object, writer);
    }

    public void write(Object object, JsonGenerator jsonGenerator) throws IOException {
        EJsonWriter.write(object, jsonGenerator);
    }

    public void writeCollection(Collection<Object> collection, JsonGenerator jsonGenerator) throws IOException {
        EJsonWriter.writeCollection(collection, jsonGenerator);
    }

    public Map<String, Object> parseObject(String json, boolean modifyAware) throws IOException {
        return EJsonReader.parseObject(json, modifyAware);
    }

    public Map<String, Object> parseObject(String json) throws IOException {
        return EJsonReader.parseObject(json);
    }

    public Map<String, Object> parseObject(Reader reader, boolean modifyAware) throws IOException {
        return EJsonReader.parseObject(reader, modifyAware);
    }

    public Map<String, Object> parseObject(Reader reader) throws IOException {
        return EJsonReader.parseObject(reader);
    }

    public Map<String, Object> parseObject(JsonParser parser) throws IOException {
        return EJsonReader.parseObject(parser);
    }

    public Map<String, Object> parseObject(JsonParser parser, JsonToken token) throws IOException {
        return EJsonReader.parseObject(parser, token);
    }

    public <T> List<T> parseList(String json, boolean modifyAware) throws IOException {
        return EJsonReader.parseList(json, modifyAware);
    }

    public List<Object> parseList(String json) throws IOException {
        return EJsonReader.parseList(json);
    }

    public List<Object> parseList(Reader reader) throws IOException {
        return EJsonReader.parseList(reader);
    }

    public List<Object> parseList(JsonParser parser) throws IOException {
        return EJsonReader.parseList(parser, false);
    }

    public <T> List<T> parseList(JsonParser parser, JsonToken currentToken) throws IOException {
        return (List)EJsonReader.parse(parser, currentToken, false);
    }

    public Object parse(String json) throws IOException {
        return EJsonReader.parse(json);
    }

    public Object parse(Reader reader) throws IOException {
        return EJsonReader.parse(reader);
    }

    public Object parse(JsonParser parser) throws IOException {
        return EJsonReader.parse(parser);
    }

    public <T> Set<T> parseSet(String json, boolean modifyAware) throws IOException {
        List<T> list = this.parseList(json, modifyAware);
        if (list == null) {
            return null;
        }
        if (modifyAware) {
            return ((ModifyAwareList)list).asSet();
        }
        return new LinkedHashSet<T>(list);
    }

    public <T> Set<T> parseSet(JsonParser parser, JsonToken currentToken) throws IOException {
        return new LinkedHashSet<T>(this.parseList(parser, currentToken));
    }
}

