/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.BatchedPstmt;
import io.ebeaninternal.server.persist.BatchedPstmtHolder;
import io.ebeaninternal.server.persist.TrimLogSql;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class PstmtFactory {
    PstmtFactory() {
    }

    CallableStatement getCstmt(SpiTransaction t, String sql) throws SQLException {
        Connection conn = t.getInternalConnection();
        return conn.prepareCall(sql);
    }

    PreparedStatement getPstmt(SpiTransaction t, String sql, boolean getGeneratedKeys) throws SQLException {
        Connection conn = t.getInternalConnection();
        if (getGeneratedKeys) {
            return conn.prepareStatement(sql, 1);
        }
        return conn.prepareStatement(sql);
    }

    PreparedStatement getPstmtBatch(SpiTransaction t, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().getPstmtHolder();
        BatchedPstmt existingStmt = batch.getBatchedPstmt(sql);
        if (existingStmt != null) {
            if (existingStmt.isEmpty() && t.isLogSql()) {
                t.logSql(TrimLogSql.trim(sql));
            }
            return existingStmt.getStatement(batchExe);
        }
        if (t.isLogSql()) {
            t.logSql(TrimLogSql.trim(sql));
        }
        Connection conn = t.getInternalConnection();
        PreparedStatement stmt = conn.prepareStatement(sql);
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, t);
        batch.addStmt(bs, batchExe);
        return stmt;
    }

    CallableStatement getCstmtBatch(SpiTransaction t, boolean logSql, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().getPstmtHolder();
        CallableStatement stmt = (CallableStatement)batch.getStmt(sql, batchExe);
        if (stmt != null) {
            return stmt;
        }
        if (logSql) {
            t.logSql(sql);
        }
        Connection conn = t.getInternalConnection();
        stmt = conn.prepareCall(sql);
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, t);
        batch.addStmt(bs, batchExe);
        return stmt;
    }
}

