/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.Expression;
import io.ebean.Junction;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NestedPathWrapperExpression;
import java.io.IOException;

abstract class LogicExpression
implements SpiExpression {
    static final String AND = " and ";
    static final String OR = " or ";
    SpiExpression expOne;
    SpiExpression expTwo;
    private final boolean conjunction;

    LogicExpression(boolean conjunction, Expression expOne, Expression expTwo) {
        this.conjunction = conjunction;
        this.expOne = (SpiExpression)expOne;
        this.expTwo = (SpiExpression)expTwo;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.startBool(this.conjunction ? Junction.Type.AND : Junction.Type.OR);
        this.expOne.writeDocQuery(context);
        this.expTwo.writeDocQuery(context);
        context.endBool();
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        String pathOne = this.expOne.nestedPath(desc);
        String pathTwo = this.expTwo.nestedPath(desc);
        if (pathOne == null && pathTwo == null) {
            return null;
        }
        if (pathOne != null && pathOne.equals(pathTwo)) {
            return pathOne;
        }
        if (pathOne != null) {
            this.expOne = new NestedPathWrapperExpression(pathOne, this.expOne);
        }
        if (pathTwo != null) {
            this.expTwo = new NestedPathWrapperExpression(pathTwo, this.expTwo);
        }
        return null;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        boolean parentOuterJoins = manyWhereJoin.isRequireOuterJoins();
        if (!this.conjunction) {
            manyWhereJoin.setRequireOuterJoins(true);
        }
        this.expOne.containsMany(desc, manyWhereJoin);
        this.expTwo.containsMany(desc, manyWhereJoin);
        if (!this.conjunction && !parentOuterJoins) {
            manyWhereJoin.setRequireOuterJoins(false);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        this.expOne.validate(validation);
        this.expTwo.validate(validation);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        this.expOne.addBindValues(request);
        this.expTwo.addBindValues(request);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append("(");
        this.expOne.addSql(request);
        request.append(this.conjunction ? AND : OR);
        this.expTwo.addSql(request);
        request.append(")");
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.expOne.prepareExpression(request);
        this.expTwo.prepareExpression(request);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Logic").append(this.conjunction ? AND : OR).append("[");
        this.expOne.queryPlanHash(builder);
        builder.append(",");
        this.expTwo.queryPlanHash(builder);
        builder.append("]");
    }

    @Override
    public int queryBindHash() {
        int hc = this.expOne.queryBindHash();
        hc = hc * 92821 + this.expTwo.queryBindHash();
        return hc;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        LogicExpression that = (LogicExpression)other;
        return this.expOne.isSameByBind(that.expOne) && this.expTwo.isSameByBind(that.expTwo);
    }

    static class Or
    extends LogicExpression {
        Or(Expression expOne, Expression expTwo) {
            super(false, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new Or(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }

    static class And
    extends LogicExpression {
        And(Expression expOne, Expression expTwo) {
            super(true, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new And(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }
}

