/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.PathProperties;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanCascadeInfo;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.BeanPropertyOverride;
import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.ExportedProperty;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.id.ImportedIdEmbedded;
import io.ebeaninternal.server.deploy.id.ImportedIdSimple;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.el.ElPropertyChainBuilder;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.querydefn.DefaultOrmQuery;
import io.ebeanservice.docstore.api.mapping.DocMappingBuilder;
import io.ebeanservice.docstore.api.mapping.DocPropertyMapping;
import io.ebeanservice.docstore.api.support.DocStructure;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanPropertyAssoc<T>
extends BeanProperty
implements STreePropertyAssoc {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyAssoc.class);
    BeanDescriptor<T> targetDescriptor;
    IdBinder targetIdBinder;
    InheritInfo targetInheritInfo;
    String targetIdProperty;
    ExportedProperty[] exportedProperties;
    final BeanCascadeInfo cascadeInfo;
    final TableJoin tableJoin;
    final PropertyForeignKey foreignKey;
    private final Class<T> targetType;
    final BeanTable beanTable;
    final String mappedBy;
    private final String docStoreDoc;
    private final String extraWhere;
    private final int fetchPreference;
    private boolean saveRecurseSkippable;

    BeanPropertyAssoc(BeanDescriptor<?> descriptor, DeployBeanPropertyAssoc<T> deploy) {
        super(descriptor, deploy);
        this.foreignKey = deploy.getForeignKey();
        this.extraWhere = InternString.intern(deploy.getExtraWhere());
        this.beanTable = deploy.getBeanTable();
        this.mappedBy = InternString.intern(deploy.getMappedBy());
        this.docStoreDoc = deploy.getDocStoreDoc();
        this.tableJoin = new TableJoin(deploy.getTableJoin());
        this.targetType = deploy.getTargetType();
        this.cascadeInfo = deploy.getCascadeInfo();
        this.fetchPreference = deploy.getFetchPreference();
    }

    BeanPropertyAssoc(BeanPropertyAssoc source, BeanPropertyOverride override) {
        super(source, override);
        this.foreignKey = source.foreignKey;
        this.extraWhere = source.extraWhere;
        this.beanTable = source.beanTable;
        this.mappedBy = source.mappedBy;
        this.docStoreDoc = source.docStoreDoc;
        this.targetType = source.targetType;
        this.cascadeInfo = source.cascadeInfo;
        this.fetchPreference = source.fetchPreference;
        this.tableJoin = source.tableJoin.withOverrideColumn(override.getDbColumn());
    }

    @Override
    public void initialise(BeanDescriptorInitContext initContext) {
        this.initialiseTargetDescriptor(initContext);
    }

    void initialiseTargetDescriptor(BeanDescriptorInitContext initContext) {
        this.targetDescriptor = this.descriptor.getBeanDescriptor(this.targetType);
        if (!this.isTransient) {
            this.targetIdBinder = this.targetDescriptor.getIdBinder();
            this.targetInheritInfo = this.targetDescriptor.getInheritInfo();
            this.saveRecurseSkippable = this.targetDescriptor.isSaveRecurseSkippable();
            if (!this.targetIdBinder.isComplexId()) {
                this.targetIdProperty = this.targetIdBinder.getIdProperty();
            }
        }
    }

    @Override
    public int getFetchPreference() {
        return this.fetchPreference;
    }

    public PropertyForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public boolean hasForeignKeyConstraint() {
        return this.foreignKey == null || !this.foreignKey.isNoConstraint();
    }

    public boolean hasForeignKeyIndex() {
        return this.foreignKey == null || !this.foreignKey.isNoIndex();
    }

    ElPropertyValue createElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        BeanDescriptor<T> embDesc = this.getTargetDescriptor();
        if (chain == null) {
            chain = new ElPropertyChainBuilder(this.isEmbedded(), propName);
        }
        chain.add(this);
        if (this.containsMany()) {
            chain.setContainsMany();
        }
        return embDesc.buildElGetValue(remainder, chain, propertyDeploy);
    }

    @Override
    public SqlJoinType addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx) {
        return this.tableJoin.addJoin(joinType, prefix, ctx);
    }

    @Override
    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        return this.tableJoin.addJoin(joinType, a1, a2, ctx);
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public String getTargetIdProperty() {
        return this.targetIdProperty;
    }

    public BeanDescriptor<T> getTargetDescriptor() {
        return this.targetDescriptor;
    }

    SpiEbeanServer server() {
        return this.descriptor.getEbeanServer();
    }

    public SpiQuery<T> newQuery(SpiEbeanServer server) {
        return new DefaultOrmQuery<T>(this.targetDescriptor, server, server.getExpressionFactory());
    }

    @Override
    public IdBinder getIdBinder() {
        return this.descriptor.getIdBinder();
    }

    @Override
    public STreeType target() {
        return this.targetDescriptor;
    }

    public boolean isTargetSoftDelete() {
        return this.targetDescriptor.isSoftDelete();
    }

    boolean isCascadeRefresh() {
        return this.cascadeInfo.isRefresh();
    }

    public boolean isSaveRecurseSkippable(Object bean) {
        return this.saveRecurseSkippable && bean instanceof EntityBean && !((EntityBean)bean)._ebean_getIntercept().isNewOrDirty();
    }

    public boolean isSaveRecurseSkippable() {
        return this.saveRecurseSkippable;
    }

    public boolean hasId(EntityBean bean) {
        BeanDescriptor<T> targetDesc = this.getTargetDescriptor();
        BeanProperty idProp = targetDesc.getIdProperty();
        return idProp == null || idProp.getValue(bean) != null;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public String getExtraWhere() {
        return this.extraWhere;
    }

    private String getDocStoreDoc() {
        return this.docStoreDoc;
    }

    @Override
    public void docStoreInclude(boolean includeByDefault, DocStructure docStructure) {
        String embeddedDoc = this.getDocStoreDoc();
        if (embeddedDoc == null) {
            if (includeByDefault) {
                this.docStoreIncludeByDefault(docStructure.doc());
            }
        } else {
            if (embeddedDoc.isEmpty()) {
                embeddedDoc = "*";
            }
            PathProperties embDoc = PathProperties.parse((String)embeddedDoc);
            docStructure.addNested(this.name, embDoc);
        }
    }

    void docStoreIncludeByDefault(PathProperties pathProps) {
        pathProps.addToPath(null, this.name);
    }

    @Override
    public void docStoreMapping(DocMappingBuilder mapping, String prefix) {
        if (mapping.includesPath(prefix, this.name)) {
            String fullName = SplitName.add((String)prefix, (String)this.name);
            DocPropertyType type = this.isMany() ? DocPropertyType.LIST : DocPropertyType.OBJECT;
            DocPropertyMapping nested = new DocPropertyMapping(this.name, type);
            mapping.push(nested);
            this.targetDescriptor.docStoreMapping(mapping, fullName);
            mapping.pop();
            if (!nested.getChildren().isEmpty()) {
                mapping.add(nested);
            }
        }
    }

    public boolean isUpdateable() {
        TableJoinColumn[] columns = this.tableJoin.columns();
        if (columns.length <= 0) {
            return true;
        }
        for (TableJoinColumn column : columns) {
            if (!column.isUpdateable()) continue;
            return true;
        }
        return false;
    }

    public boolean isInsertable() {
        TableJoinColumn[] columns = this.tableJoin.columns();
        if (columns.length <= 0) {
            return true;
        }
        for (TableJoinColumn column : columns) {
            if (!column.isInsertable()) continue;
            return true;
        }
        return false;
    }

    public BeanTable getBeanTable() {
        return this.beanTable;
    }

    public TableJoin getTableJoin() {
        return this.tableJoin;
    }

    public BeanCascadeInfo getCascadeInfo() {
        return this.cascadeInfo;
    }

    ImportedId createImportedId(BeanPropertyAssoc<?> owner, BeanDescriptor<?> target, TableJoin join) {
        BeanProperty idProp = target.getIdProperty();
        BeanProperty[] others = target.propertiesBaseScalar();
        if (this.descriptor.isRawSqlBased()) {
            String dbColumn = owner.getDbColumn();
            return new ImportedIdSimple(owner, dbColumn, null, idProp, 0);
        }
        TableJoinColumn[] cols = join.columns();
        if (idProp == null) {
            return null;
        }
        if (!idProp.isEmbedded()) {
            if (cols.length != 1) {
                String msg = "No Imported Id column for [" + idProp + "] in table [" + join.getTable() + "]";
                logger.error(msg);
                return null;
            }
            BeanProperty[] idProps = new BeanProperty[]{idProp};
            return this.createImportedScalar(owner, cols[0], idProps, others);
        }
        BeanPropertyAssocOne embProp = (BeanPropertyAssocOne)idProp;
        BeanProperty[] embBaseProps = embProp.getTargetDescriptor().propertiesBaseScalar();
        ImportedIdSimple[] scalars = this.createImportedList(owner, cols, embBaseProps, others);
        return new ImportedIdEmbedded(owner, embProp, scalars);
    }

    private ImportedIdSimple[] createImportedList(BeanPropertyAssoc<?> owner, TableJoinColumn[] cols, BeanProperty[] props, BeanProperty[] others) {
        ArrayList<ImportedIdSimple> list = new ArrayList<ImportedIdSimple>(cols.length);
        for (TableJoinColumn col : cols) {
            list.add(this.createImportedScalar(owner, col, props, others));
        }
        return ImportedIdSimple.sort(list);
    }

    private ImportedIdSimple createImportedScalar(BeanPropertyAssoc<?> owner, TableJoinColumn col, BeanProperty[] props, BeanProperty[] others) {
        int j;
        String matchColumn = col.getForeignDbColumn();
        String localColumn = col.getLocalDbColumn();
        String localSqlFormula = col.getLocalSqlFormula();
        boolean insertable = col.isInsertable();
        boolean updateable = col.isUpdateable();
        for (j = 0; j < props.length; ++j) {
            if (!props[j].getDbColumn().equalsIgnoreCase(matchColumn)) continue;
            return new ImportedIdSimple(owner, localColumn, localSqlFormula, props[j], j, insertable, updateable);
        }
        for (j = 0; j < others.length; ++j) {
            if (!others[j].getDbColumn().equalsIgnoreCase(matchColumn)) continue;
            return new ImportedIdSimple(owner, localColumn, localSqlFormula, others[j], j + props.length, insertable, updateable);
        }
        String msg = "Error with the Join on [" + this.getFullBeanName() + "]. Could not find the local match for [" + matchColumn + "]  Perhaps an error in a @JoinColumn";
        throw new PersistenceException(msg);
    }

    private List<Object> flattenParentIds(List<Object> parentIds) {
        ArrayList<Object> bindValues = new ArrayList<Object>(parentIds.size() * 3);
        for (Object parentId : parentIds) {
            this.flatten(bindValues, parentId);
        }
        return bindValues;
    }

    private List<Object> flattenParentId(Object parentId) {
        ArrayList<Object> bindValues = new ArrayList<Object>();
        this.flatten(bindValues, parentId);
        return bindValues;
    }

    private void flatten(List<Object> bindValues, Object parentId) {
        if (this.isExportedSimple()) {
            bindValues.add(parentId);
        } else {
            EntityBean parent = (EntityBean)parentId;
            for (ExportedProperty exportedProperty : this.exportedProperties) {
                bindValues.add(exportedProperty.getValue(parent));
            }
        }
    }

    void bindParentIds(DefaultSqlUpdate delete, List<Object> parentIds) {
        if (this.isExportedSimple()) {
            delete.setParameter(new MultiValueWrapper(parentIds));
        } else {
            List<Object> bindValues = this.flattenParentIds(parentIds);
            for (Object bindValue : bindValues) {
                delete.setParameter(bindValue);
            }
        }
    }

    void bindParentId(DefaultSqlUpdate sqlUpd, Object parentId) {
        if (this.isExportedSimple()) {
            sqlUpd.setParameter(parentId);
            return;
        }
        EntityBean parent = (EntityBean)parentId;
        for (ExportedProperty exportedProperty : this.exportedProperties) {
            sqlUpd.setParameter(exportedProperty.getValue(parent));
        }
    }

    void bindParentIdEq(String expr, Object parentId, Query<?> q) {
        if (this.isExportedSimple()) {
            q.where().raw(expr, parentId);
        } else {
            List<Object> bindValues = this.flattenParentId(parentId);
            q.where().raw(expr, bindValues.toArray());
        }
    }

    void bindParentIdsIn(String expr, List<Object> parentIds, Query<?> q) {
        if (this.isExportedSimple()) {
            q.where().raw(expr, (Object)new MultiValueWrapper(parentIds));
        } else {
            List<Object> bindValues = this.flattenParentIds(parentIds);
            q.where().raw(expr, bindValues.toArray());
        }
    }

    private boolean isExportedSimple() {
        return this.exportedProperties.length == 1;
    }

    ExportedProperty findMatch(boolean embedded, BeanProperty prop, String matchColumn, TableJoin tableJoin) {
        String searchTable = tableJoin.getTable();
        for (TableJoinColumn column : tableJoin.columns()) {
            String matchTo = column.getLocalDbColumn();
            if (!matchColumn.equalsIgnoreCase(matchTo)) continue;
            String foreignCol = column.getForeignDbColumn();
            return new ExportedProperty(embedded, foreignCol, prop);
        }
        String msg = "Error with the Join on [" + this.getFullBeanName() + "]. Could not find the matching foreign key for [" + matchColumn + "] in table[" + searchTable + "]? Perhaps using a @JoinColumn with the name/referencedColumnName attributes swapped?";
        throw new PersistenceException(msg);
    }
}

