/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Year;

final class ScalarTypeYear
extends ScalarTypeBase<Year> {
    ScalarTypeYear() {
        super(Year.class, false, 4);
    }

    public void bind(DataBinder binder, Year value) throws SQLException {
        if (value == null) {
            binder.setNull(4);
        } else {
            binder.setInt(value.getValue());
        }
    }

    public Year read(DataReader reader) throws SQLException {
        Integer value = reader.getInt();
        return value == null ? null : Year.of(value);
    }

    public Year readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return Year.of(dataInput.readInt());
    }

    public void writeData(DataOutput dataOutput, Year value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(value.getValue());
        }
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Year) {
            return ((Year)value).getValue();
        }
        return BasicTypeConverter.toInteger(value);
    }

    public Year toBeanType(Object value) {
        if (value instanceof Year) {
            return (Year)value;
        }
        if (value == null) {
            return null;
        }
        return Year.of(BasicTypeConverter.toInteger(value));
    }

    public String formatValue(Year v) {
        return v.toString();
    }

    public Year parse(String value) {
        return Year.parse(value);
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public Year convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    public Year jsonRead(JsonParser parser) throws IOException {
        return Year.of(parser.getIntValue());
    }

    public void jsonWrite(JsonGenerator writer, Year value) throws IOException {
        writer.writeNumber(value.getValue());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.INTEGER;
    }
}

