/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBaseDate;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

final class ScalarTypeLocalDate
extends ScalarTypeBaseDate<LocalDate> {
    ScalarTypeLocalDate(JsonConfig.Date mode) {
        super(mode, LocalDate.class, false, 91);
    }

    @Override
    protected String toIsoFormat(LocalDate value) {
        return value.toString();
    }

    @Override
    public LocalDate convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis).toLocalDateTime().toLocalDate();
    }

    @Override
    public long convertToMillis(LocalDate value) {
        ZonedDateTime zonedDateTime = value.atStartOfDay(ZoneOffset.UTC);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public LocalDate convertFromDate(Date ts) {
        return ts.toLocalDate();
    }

    @Override
    public Date convertToDate(LocalDate t) {
        return Date.valueOf(t);
    }

    public Object toJdbcType(Object value) {
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        return BasicTypeConverter.toDate(value);
    }

    public LocalDate toBeanType(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        return (LocalDate)value;
    }
}

