/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeJsonMapPostgres;
import io.ebeaninternal.server.type.TypeJsonManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;

abstract class ScalarTypeJsonMap
extends ScalarTypeBase<Map> {
    final boolean keepSource;

    static ScalarTypeJsonMap typeFor(boolean postgres, int dbType, boolean keepSource) {
        switch (dbType) {
            case 12: {
                return new Varchar(keepSource);
            }
            case 2004: {
                return new Blob(keepSource);
            }
            case 2005: {
                return new Clob(keepSource);
            }
            case 5002: {
                return postgres ? new ScalarTypeJsonMapPostgres.JSONB(keepSource) : new Clob(keepSource);
            }
            case 5001: {
                return postgres ? new ScalarTypeJsonMapPostgres.JSON(keepSource) : new Clob(keepSource);
            }
        }
        throw new IllegalStateException("Unknown dbType " + dbType);
    }

    ScalarTypeJsonMap(int jdbcType, boolean keepSource) {
        super(Map.class, false, jdbcType);
        this.keepSource = keepSource;
    }

    @Override
    public final boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return TypeJsonManager.checkIsDirty(value);
    }

    public final boolean isJsonMapper() {
        return this.keepSource;
    }

    public Map read(DataReader reader) throws SQLException {
        String rawJson = this.readJson(reader);
        if (this.keepSource) {
            reader.pushJson(rawJson);
        }
        if (rawJson == null) {
            return null;
        }
        return this.parse(rawJson);
    }

    protected String readJson(DataReader reader) throws SQLException {
        return reader.getString();
    }

    public final void bind(DataBinder binder, Map value) throws SQLException {
        String rawJson;
        String string = rawJson = this.keepSource ? binder.popJson() : null;
        if (rawJson == null && value != null) {
            rawJson = this.formatValue(value);
        }
        if (value == null) {
            this.bindNull(binder);
        } else {
            this.bindJson(binder, rawJson);
        }
    }

    protected void bindNull(DataBinder binder) throws SQLException {
        binder.setNull(12);
    }

    protected void bindJson(DataBinder binder, String rawJson) throws SQLException {
        binder.setString(rawJson);
    }

    public final Object toJdbcType(Object value) {
        return value;
    }

    public final Map toBeanType(Object value) {
        return (Map)value;
    }

    public final String formatValue(Map v) {
        try {
            return EJson.write((Object)v);
        }
        catch (IOException e) {
            throw new TextException((Exception)e);
        }
    }

    public final Map parse(String value) {
        try {
            return EJson.parseObject((String)value, (boolean)true);
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as Object", value, (Exception)e);
        }
    }

    public final Map parse(Reader reader) {
        try {
            return EJson.parseObject((Reader)reader, (boolean)true);
        }
        catch (IOException e) {
            throw new TextException((Exception)e);
        }
    }

    public final Map convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    public final boolean isDateTimeCapable() {
        return false;
    }

    public final Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    public final void writeData(DataOutput dataOutput, Map map) throws IOException {
        if (map == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(map));
        }
    }

    public final void jsonWrite(JsonGenerator writer, Map value) throws IOException {
        EJson.write((Object)value, (JsonGenerator)writer);
    }

    public final Map jsonRead(JsonParser parser) throws IOException {
        return EJson.parseObject((JsonParser)parser, (JsonToken)parser.getCurrentToken());
    }

    public final DocPropertyType getDocType() {
        return DocPropertyType.OBJECT;
    }

    private static final class Blob
    extends ScalarTypeJsonMap {
        Blob(boolean keepSource) {
            super(2004, keepSource);
        }

        @Override
        public Map read(DataReader reader) throws SQLException {
            Map map;
            InputStream is = reader.getBinaryStream();
            if (is == null) {
                if (this.keepSource) {
                    reader.pushJson(null);
                }
                return null;
            }
            if (this.keepSource) {
                StringWriter jsonBuffer = new StringWriter();
                try (InputStreamReader streamReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Blob.transferTo(streamReader, jsonBuffer);
                }
                String rawJson = jsonBuffer.toString();
                reader.pushJson(rawJson);
                return this.parse(rawJson);
            }
            InputStreamReader streamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
            try {
                map = this.parse(streamReader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        streamReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("Error reading Blob stream from DB", e);
                }
            }
            streamReader.close();
            return map;
        }

        private static void transferTo(Reader reader, Writer out) throws IOException {
            int nRead;
            char[] buffer = new char[2048];
            while ((nRead = reader.read(buffer, 0, 2048)) >= 0) {
                out.write(buffer, 0, nRead);
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            binder.setNull(2004);
        }

        @Override
        protected void bindJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setBytes(rawJson.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static final class Varchar
    extends ScalarTypeJsonMap {
        Varchar(boolean keepSource) {
            super(12, keepSource);
        }
    }

    private static final class Clob
    extends ScalarTypeJsonMap {
        Clob(boolean keepSource) {
            super(2005, keepSource);
        }

        @Override
        protected String readJson(DataReader reader) throws SQLException {
            return reader.getStringFromStream();
        }
    }
}

