/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;

final class DecimalUtils {
    private static final char[] ZEROES = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);

    private DecimalUtils() {
        throw new RuntimeException("DecimalUtils cannot be instantiated.");
    }

    static Duration toDuration(BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = DecimalUtils.extractNanosecondDecimal(value, seconds);
        return Duration.ofSeconds(seconds, nanoseconds);
    }

    static BigDecimal toDecimal(Duration instant) {
        return new BigDecimal(DecimalUtils.toDecimal(instant.getSeconds(), instant.getNano()));
    }

    static Timestamp toTimestamp(BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = DecimalUtils.extractNanosecondDecimal(value, seconds);
        Timestamp ts = new Timestamp(seconds * 1000L);
        ts.setNanos(nanoseconds);
        return ts;
    }

    static BigDecimal toDecimal(Timestamp instant) {
        long millis = instant.getTime();
        long secs = millis / 1000L;
        return new BigDecimal(DecimalUtils.toDecimal(secs, instant.getNanos()));
    }

    static Instant toInstant(BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = DecimalUtils.extractNanosecondDecimal(value, seconds);
        return Instant.ofEpochSecond(seconds, nanoseconds);
    }

    static BigDecimal toDecimal(Instant instant) {
        return new BigDecimal(DecimalUtils.toDecimal(instant.getEpochSecond(), instant.getNano()));
    }

    static String toDecimal(long seconds, int nanoseconds) {
        StringBuilder string = new StringBuilder(Integer.toString(nanoseconds));
        if (string.length() < 9) {
            string.insert(0, ZEROES, 0, 9 - string.length());
        }
        return seconds + "." + string;
    }

    static int extractNanosecondDecimal(BigDecimal value, long integer) {
        return value.subtract(new BigDecimal(integer)).multiply(ONE_BILLION).intValue();
    }
}

