/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.ExpressionList;
import io.ebean.ProfileLocation;
import io.ebean.UpdateQuery;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.querydefn.DefaultOrmQuery;
import io.ebeaninternal.server.querydefn.OrmUpdateProperties;

public final class DefaultUpdateQuery<T>
implements UpdateQuery<T> {
    private final OrmUpdateProperties values = new OrmUpdateProperties();
    private final DefaultOrmQuery<T> query;
    private final BeanDescriptor<T> descriptor;

    public DefaultUpdateQuery(DefaultOrmQuery<T> query) {
        this.query = query;
        this.descriptor = query.getBeanDescriptor();
        query.setUpdateProperties(this.values);
    }

    public UpdateQuery<T> set(String property, Object value) {
        if (value == null) {
            this.values.setNull(property);
        } else {
            BeanProperty beanProperty = this.descriptor.beanProperty(property);
            ScalarType<Object> scalarType = beanProperty == null ? null : beanProperty.scalarType();
            this.values.set(property, value, scalarType);
        }
        return this;
    }

    public UpdateQuery<T> setNull(String property) {
        this.values.setNull(property);
        return this;
    }

    public UpdateQuery<T> setRaw(String propertyExpression) {
        this.values.setRaw(propertyExpression);
        return this;
    }

    public UpdateQuery<T> setRaw(String propertyExpression, Object ... vals) {
        this.values.setRaw(propertyExpression, vals);
        return this;
    }

    public UpdateQuery<T> setProfileLocation(ProfileLocation profileLocation) {
        this.query.setProfileLocation(profileLocation);
        return this;
    }

    public UpdateQuery<T> setLabel(String label) {
        this.query.setLabel(label);
        return this;
    }

    public ExpressionList<T> where() {
        return this.query.where();
    }

    public int update() {
        return this.query.update();
    }
}

