/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.query.QueryPlanLogger;
import io.ebeaninternal.server.type.bindcapture.BindCapture;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class QueryPlanLoggerExplain
extends QueryPlanLogger {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpiDbQueryPlan collectPlan(Connection conn, SpiQueryPlan plan, BindCapture bind) {
        try (PreparedStatement explainStmt = conn.prepareStatement("EXPLAIN " + plan.getSql());){
            SpiDbQueryPlan spiDbQueryPlan;
            block14: {
                bind.prepare(explainStmt, conn);
                ResultSet rset = explainStmt.executeQuery();
                try {
                    spiDbQueryPlan = this.readQueryPlan(plan, bind, rset);
                    if (rset == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rset.close();
            }
            return spiDbQueryPlan;
        }
        catch (SQLException e) {
            CoreLog.log.warn("Could not log query plan", (Throwable)e);
            return null;
        }
    }
}

