/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.SqlRow;
import io.ebeaninternal.server.core.BasicTypeConverter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class DefaultSqlRow
implements SqlRow {
    private static final long serialVersionUID = -3120927797041336242L;
    private final String dbTrueValue;
    private final boolean optimizedBinaryUUID;
    private final Map<String, Object> map;

    public DefaultSqlRow(int initialCapacity, float loadFactor, String dbTrueValue, boolean optimizedBinaryUUID) {
        this.map = new LinkedHashMap<String, Object>(initialCapacity, loadFactor);
        this.dbTrueValue = dbTrueValue;
        this.optimizedBinaryUUID = optimizedBinaryUUID;
    }

    public Iterator<String> keys() {
        return this.map.keySet().iterator();
    }

    private Object asKey(Object name) {
        return ((String)name).toLowerCase();
    }

    public Object remove(Object name) {
        return this.map.remove(this.asKey(name));
    }

    public Object get(Object name) {
        return this.map.get(this.asKey(name));
    }

    public Object put(String name, Object value) {
        return this.setInternal(name, value);
    }

    public Object set(String name, Object value) {
        return this.setInternal(name, value);
    }

    private Object setInternal(String name, Object newValue) {
        return this.map.put(name.toLowerCase(), newValue);
    }

    public UUID getUUID(String name) {
        return BasicTypeConverter.toUUID(this.get(name), this.optimizedBinaryUUID);
    }

    public Boolean getBoolean(String name) {
        return BasicTypeConverter.toBoolean(this.get(name), this.dbTrueValue);
    }

    public Integer getInteger(String name) {
        return BasicTypeConverter.toInteger(this.get(name));
    }

    public BigDecimal getBigDecimal(String name) {
        return BasicTypeConverter.toBigDecimal(this.get(name));
    }

    public Long getLong(String name) {
        return BasicTypeConverter.toLong(this.get(name));
    }

    public Double getDouble(String name) {
        return BasicTypeConverter.toDouble(this.get(name));
    }

    public Float getFloat(String name) {
        return BasicTypeConverter.toFloat(this.get(name));
    }

    public String getString(String name) {
        return BasicTypeConverter.toString(this.get(name));
    }

    public Date getUtilDate(String name) {
        return BasicTypeConverter.toUtilDate(this.get(name));
    }

    public java.sql.Date getDate(String name) {
        return BasicTypeConverter.toDate(this.get(name));
    }

    public Timestamp getTimestamp(String name) {
        return BasicTypeConverter.toTimestamp(this.get(name));
    }

    public String toString() {
        return this.map.toString();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(this.asKey(key));
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void putAll(Map<? extends String, ?> t) {
        this.map.putAll(t);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Object> values() {
        return this.map.values();
    }
}

