/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.properties;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.properties.BeanPropertyAccess;
import io.ebeaninternal.server.properties.BeanPropertyGetter;
import io.ebeaninternal.server.properties.BeanPropertySetter;

public final class EnhanceBeanPropertyAccess
implements BeanPropertyAccess {
    private static final int CACHE_SIZE = 30;
    private final BeanPropertyGetter[] getters = this.initGetters();
    private final BeanPropertySetter[] setters = this.initSetters();

    private BeanPropertyGetter[] initGetters() {
        BeanPropertyGetter[] getters = new BeanPropertyGetter[30];
        for (int i = 0; i < 30; ++i) {
            getters[i] = new Getter(i);
        }
        return getters;
    }

    private BeanPropertySetter[] initSetters() {
        BeanPropertySetter[] setters = new BeanPropertySetter[30];
        for (int i = 0; i < 30; ++i) {
            setters[i] = new Setter(i);
        }
        return setters;
    }

    @Override
    public BeanPropertyGetter getGetter(int position) {
        if (position < 30) {
            return this.getters[position];
        }
        return new Getter(position);
    }

    @Override
    public BeanPropertySetter getSetter(int position) {
        if (position < 30) {
            return this.setters[position];
        }
        return new Setter(position);
    }

    private static final class Setter
    implements BeanPropertySetter {
        private final int fieldIndex;

        Setter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public void set(EntityBean bean, Object value) {
            bean._ebean_setField(this.fieldIndex, value);
        }

        @Override
        public void setIntercept(EntityBean bean, Object value) {
            bean._ebean_setFieldIntercept(this.fieldIndex, value);
        }
    }

    private static final class Getter
    implements BeanPropertyGetter {
        private final int fieldIndex;

        Getter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public Object get(EntityBean bean) {
            return bean._ebean_getField(this.fieldIndex);
        }

        @Override
        public Object getIntercept(EntityBean bean) {
            return bean._ebean_getFieldIntercept(this.fieldIndex);
        }
    }
}

