/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.TimedMetric;
import io.ebeaninternal.server.profile.DTimeMetricStats;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

final class DTimedMetric
implements TimedMetric {
    private final String name;
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final LongAccumulator max = new LongAccumulator(Math::max, Long.MIN_VALUE);
    private boolean collected;

    DTimedMetric(String name) {
        this.name = name;
    }

    public void addBatchSince(long startNanos, int batch) {
        if (batch > 0) {
            long totalMicros = (System.nanoTime() - startNanos) / 1000L;
            long mean = totalMicros / (long)batch;
            this.count.add(batch);
            this.total.add(totalMicros);
            this.max.accumulate(mean);
        }
    }

    public void addSinceNanos(long startNanos) {
        this.add((System.nanoTime() - startNanos) / 1000L);
    }

    public void add(long value) {
        this.count.increment();
        this.total.add(value);
        this.max.accumulate(value);
    }

    public boolean isEmpty() {
        return this.count.sum() == 0L;
    }

    public void reset() {
        this.max.reset();
        this.count.reset();
        this.total.reset();
    }

    public void visit(MetricVisitor visitor) {
        DTimeMetricStats metric = this.collect(visitor.reset());
        if (metric != null) {
            visitor.visitTimed((MetaTimedMetric)metric);
        }
    }

    public DTimeMetricStats collect(boolean reset) {
        return this.count.sum() == 0L ? null : this.getStatistics(reset);
    }

    private DTimeMetricStats getStatistics(boolean reset) {
        try {
            if (reset) {
                DTimeMetricStats dTimeMetricStats = new DTimeMetricStats(this.name, this.collected, this.count.sumThenReset(), this.total.sumThenReset(), this.max.getThenReset());
                return dTimeMetricStats;
            }
            DTimeMetricStats dTimeMetricStats = new DTimeMetricStats(this.name, this.collected, this.count.sum(), this.total.sum(), this.max.get());
            return dTimeMetricStats;
        }
        finally {
            this.collected = true;
        }
    }
}

