/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.dml.BaseMeta;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import java.sql.SQLException;

final class DeleteMeta
extends BaseMeta {
    private final String sqlVersion;
    private final String sqlNone;
    private final String sqlDraftVersion;
    private final String sqlDraftNone;

    DeleteMeta(BeanDescriptor<?> desc, BindableId id, Bindable version, Bindable tenantId) {
        super(id, version, tenantId);
        String tableName = desc.baseTable();
        this.sqlNone = this.genSql(ConcurrencyMode.NONE, tableName);
        this.sqlVersion = this.genSql(ConcurrencyMode.VERSION, tableName);
        if (desc.isDraftable()) {
            String draftTableName = desc.draftTable();
            this.sqlDraftNone = this.genSql(ConcurrencyMode.NONE, draftTableName);
            this.sqlDraftVersion = this.genSql(ConcurrencyMode.VERSION, draftTableName);
        } else {
            this.sqlDraftNone = this.sqlNone;
            this.sqlDraftVersion = this.sqlVersion;
        }
    }

    public void bind(PersistRequestBean<?> persist, DmlHandler bind) throws SQLException {
        EntityBean bean = persist.entityBean();
        this.id.dmlBind(bind, bean);
        if (this.tenantId != null) {
            this.tenantId.dmlBind(bind, bean);
        }
        if (persist.concurrencyMode() == ConcurrencyMode.VERSION) {
            this.version.dmlBind(bind, bean);
        }
    }

    public String getSql(PersistRequestBean<?> request) {
        if (this.id.isEmpty()) {
            throw new IllegalStateException("Can not deleteById on " + request.fullName() + " as no @Id property");
        }
        boolean publish = request.isPublish();
        switch (request.concurrencyMode()) {
            case NONE: {
                return publish ? this.sqlNone : this.sqlDraftNone;
            }
            case VERSION: {
                return publish ? this.sqlVersion : this.sqlDraftVersion;
            }
        }
        throw new RuntimeException("Invalid mode " + (Object)((Object)request.concurrencyMode()));
    }

    private String genSql(ConcurrencyMode conMode, String table) {
        GenerateDmlRequest request = new GenerateDmlRequest().append("delete from ").append(table).append(" where ");
        return this.appendWhere(request, conMode);
    }
}

