/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.BatchedSqlException;
import java.util.ArrayList;

final class BatchedBeanHolder {
    private final BatchControl control;
    private final String shortDesc;
    private final int order;
    private ArrayList<PersistRequest> inserts;
    private ArrayList<PersistRequest> updates;
    private ArrayList<PersistRequest> deletes;
    private boolean empty = true;

    BatchedBeanHolder(BatchControl control, BeanDescriptor<?> beanDescriptor, int order) {
        this.control = control;
        this.shortDesc = beanDescriptor.name() + ":" + order;
        this.order = order;
    }

    public int order() {
        return this.order;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    void executeNow() throws BatchedSqlException {
        if (this.deletes != null && !this.deletes.isEmpty()) {
            ArrayList<PersistRequest> bufferedDeletes = this.deletes;
            this.deletes = new ArrayList();
            this.control.executeNow(bufferedDeletes);
        }
        if (this.inserts != null && !this.inserts.isEmpty()) {
            ArrayList<PersistRequest> bufferedInserts = this.inserts;
            this.inserts = new ArrayList();
            this.control.executeNow(bufferedInserts);
        }
        if (this.updates != null && !this.updates.isEmpty()) {
            ArrayList<PersistRequest> bufferedUpdates = this.updates;
            this.updates = new ArrayList();
            this.control.executeNow(bufferedUpdates);
        }
        this.empty = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortDesc.length() + 18);
        sb.append(this.shortDesc);
        if (this.inserts != null) {
            sb.append(" i:").append(this.inserts.size());
        }
        if (this.updates != null) {
            sb.append(" u:").append(this.updates.size());
        }
        if (this.deletes != null) {
            sb.append(" d:").append(this.deletes.size());
        }
        return sb.toString();
    }

    public int append(PersistRequestBean<?> request) {
        this.empty = false;
        request.setBatched();
        switch (request.type()) {
            case INSERT: {
                if (this.inserts == null) {
                    this.inserts = new ArrayList();
                }
                this.inserts.add(request);
                return this.inserts.size();
            }
            case UPDATE: 
            case DELETE_SOFT: {
                if (this.updates == null) {
                    this.updates = new ArrayList();
                }
                this.updates.add(request);
                return this.updates.size();
            }
            case DELETE: {
                if (this.deletes == null) {
                    this.deletes = new ArrayList();
                }
                this.deletes.add(request);
                return this.deletes.size();
            }
        }
        throw new RuntimeException("Invalid type code " + (Object)((Object)request.type()));
    }
}

