/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.grammer;

import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.LikeType;
import io.ebeaninternal.server.grammer.EqlOperator;
import io.ebeaninternal.server.grammer.EqlValueType;
import io.ebeaninternal.server.grammer.OperatorMapping;
import io.ebeaninternal.server.grammer.antlr.EQLBaseListener;
import io.ebeaninternal.server.grammer.antlr.EQLParser;
import io.ebeaninternal.server.util.ArrayStack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

abstract class EqlWhereListener<T>
extends EQLBaseListener {
    private static final OperatorMapping operatorMapping = new OperatorMapping();
    ArrayStack<ExpressionList<T>> textStack;
    ArrayStack<ExpressionList<T>> whereStack;
    boolean textMode;
    private boolean inWithEmpty;
    private List<Object> inValues;
    private String inPropertyName;

    EqlWhereListener() {
    }

    abstract ExpressionList<T> peekExprList();

    abstract ExpressionFactory expressionFactory();

    abstract Object namedParam(String var1);

    abstract Object positionParam(String var1);

    private void pushExprList(ExpressionList<T> list) {
        if (this.textMode) {
            this.textStack.push(list);
        } else {
            this.whereStack.push(list);
        }
    }

    private void popJunction() {
        if (this.textMode) {
            this.textStack.pop();
        } else {
            this.whereStack.pop();
        }
    }

    private String getLeftHandSidePath(ParserRuleContext ctx) {
        TerminalNode pathToken = ctx.getToken(69, 0);
        return pathToken.getText();
    }

    @Override
    public void enterInrange_expression(EQLParser.Inrange_expressionContext ctx) {
        this.checkChildren(ctx, 5);
        String path = this.getLeftHandSidePath(ctx);
        EqlOperator op = this.getOperator(ctx);
        if (op != EqlOperator.INRANGE) {
            throw new IllegalStateException("Expecting INRANGE operator but got " + (Object)((Object)op));
        }
        this.addInRange(path, this.child(ctx, 2), this.child(ctx, 4));
    }

    @Override
    public void enterBetween_expression(EQLParser.Between_expressionContext ctx) {
        this.checkChildren(ctx, 5);
        String path = this.getLeftHandSidePath(ctx);
        EqlOperator op = this.getOperator(ctx);
        if (op != EqlOperator.BETWEEN) {
            throw new IllegalStateException("Expecting BETWEEN operator but got " + (Object)((Object)op));
        }
        this.addBetween(path, this.child(ctx, 2), this.child(ctx, 4));
    }

    @Override
    public void enterPropertyBetween_expression(EQLParser.PropertyBetween_expressionContext ctx) {
        this.checkChildren(ctx, 5);
        String rawValue = this.child(ctx, 0);
        EqlOperator op = this.getOperator(ctx);
        if (op != EqlOperator.BETWEEN) {
            throw new IllegalStateException("Expecting BETWEEN operator but got " + (Object)((Object)op));
        }
        this.addBetweenProperty(rawValue, this.child(ctx, 2), this.child(ctx, 4));
    }

    @Override
    public void enterInOrEmpty_expression(EQLParser.InOrEmpty_expressionContext ctx) {
        this.inWithEmpty = true;
        this.inValues = new ArrayList<Object>();
        this.inPropertyName = this.getLeftHandSidePath(ctx);
    }

    @Override
    public void enterIn_expression(EQLParser.In_expressionContext ctx) {
        this.inValues = new ArrayList<Object>();
        this.inPropertyName = this.getLeftHandSidePath(ctx);
    }

    @Override
    public void enterIn_value(EQLParser.In_valueContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String text = this.child(ctx, i);
            if (text.startsWith("?")) {
                this.inValues = this.toList(this.getBindValue(EqlValueType.POS_PARAM, text));
                continue;
            }
            if (this.inWithEmpty) {
                throw new IllegalArgumentException("Sorry, can only use inOrEmpty with positioned parameters");
            }
            if (!this.isValue(text)) continue;
            this.inValues.add(this.bind(text));
        }
    }

    private List<Object> toList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Set) {
            return new ArrayList<Object>((Set)value);
        }
        throw new IllegalArgumentException("Expected List of Set but got " + value);
    }

    @Override
    public void exitIn_expression(EQLParser.In_expressionContext ctx) {
        this.peekExprList().in(this.inPropertyName, this.inValues);
    }

    @Override
    public void exitInOrEmpty_expression(EQLParser.InOrEmpty_expressionContext ctx) {
        this.inWithEmpty = false;
        this.peekExprList().inOrEmpty(this.inPropertyName, this.inValues);
    }

    String child(ParserRuleContext ctx, int position) {
        ParseTree child = ctx.getChild(position);
        return child.getText();
    }

    private boolean isValue(String text) {
        return text.length() != 1 || !text.equals("(") && !text.equals(")") && !text.equals(",");
    }

    @Override
    public void enterIsNull_expression(EQLParser.IsNull_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNull(path);
    }

    @Override
    public void enterIsNotNull_expression(EQLParser.IsNotNull_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNotNull(path);
    }

    @Override
    public void enterIsEmpty_expression(EQLParser.IsEmpty_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isEmpty(path);
    }

    @Override
    public void enterIsNotEmpty_expression(EQLParser.IsNotEmpty_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNotEmpty(path);
    }

    @Override
    public void enterLike_expression(EQLParser.Like_expressionContext ctx) {
        this.addExpression(ctx);
    }

    @Override
    public void enterComparison_expression(EQLParser.Comparison_expressionContext ctx) {
        this.addExpression(ctx);
    }

    private void addExpression(ParserRuleContext ctx) {
        String rhs;
        int childCount = ctx.getChildCount();
        if (childCount < 3) {
            throw new IllegalStateException("expecting 3 children for comparison? " + ctx);
        }
        String operator = this.child(ctx, 1);
        EqlOperator op = operatorMapping.get(operator);
        if (op == null) {
            throw new IllegalStateException("No operator found for " + operator);
        }
        String path = this.getLeftHandSidePath(ctx);
        if (path.equals(rhs = this.child(ctx, 2))) {
            op = this.invert(op);
            rhs = this.child(ctx, 0);
        }
        this.addExpression(path, op, rhs);
    }

    private EqlOperator invert(EqlOperator op) {
        switch (op) {
            case EQ: {
                return EqlOperator.EQ;
            }
            case IEQ: {
                return EqlOperator.IEQ;
            }
            case INE: {
                return EqlOperator.INE;
            }
            case NE: {
                return EqlOperator.NE;
            }
            case LT: {
                return EqlOperator.GT;
            }
            case LTE: {
                return EqlOperator.GTE;
            }
            case GT: {
                return EqlOperator.LT;
            }
            case GTE: {
                return EqlOperator.LTE;
            }
            case EQORNULL: {
                return EqlOperator.EQORNULL;
            }
            case GTORNULL: {
                return EqlOperator.LEORNULL;
            }
            case LTORNULL: {
                return EqlOperator.GEORNULL;
            }
            case GEORNULL: {
                return EqlOperator.LTORNULL;
            }
            case LEORNULL: {
                return EqlOperator.GTORNULL;
            }
        }
        throw new IllegalStateException("Can not invert operator " + (Object)((Object)op));
    }

    @Override
    public void enterConditional_term(EQLParser.Conditional_termContext ctx) {
        int childCount = ctx.getChildCount();
        if (childCount > 1) {
            this.pushExprList((ExpressionList<T>)this.peekExprList().and());
        }
    }

    @Override
    public void exitConditional_term(EQLParser.Conditional_termContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    @Override
    public void enterConditional_expression(EQLParser.Conditional_expressionContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.pushExprList((ExpressionList<T>)this.peekExprList().or());
        }
    }

    @Override
    public void exitConditional_expression(EQLParser.Conditional_expressionContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    @Override
    public void enterConditional_factor(EQLParser.Conditional_factorContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.pushExprList((ExpressionList<T>)this.peekExprList().not());
        }
    }

    @Override
    public void exitConditional_factor(EQLParser.Conditional_factorContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    private EqlOperator getOperator(ParserRuleContext ctx) {
        String operator = this.child(ctx, 1);
        EqlOperator op = operatorMapping.get(operator);
        if (op == null) {
            throw new IllegalStateException("No operator found for " + operator);
        }
        return op;
    }

    void checkChildren(ParserRuleContext ctx, int min) {
        if (ctx.getChildCount() < min) {
            throw new IllegalStateException("expecting " + min + " children for comparison but got " + ctx.getChildCount());
        }
    }

    private Expression like(boolean caseInsensitive, LikeType likeType, String property, Object bindValue) {
        return this.expressionFactory().like(property, bindValue, caseInsensitive, likeType);
    }

    private Expression ieq(String property, Object bindValue) {
        return this.expressionFactory().ieqObject(property, bindValue);
    }

    private Expression ine(String property, Object bindValue) {
        return this.expressionFactory().ineObject(property, bindValue);
    }

    private EqlValueType getValueType(String valueAsText) {
        char firstChar = Character.toLowerCase(valueAsText.charAt(0));
        switch (firstChar) {
            case '?': {
                return EqlValueType.POS_PARAM;
            }
            case ':': {
                return EqlValueType.NAMED_PARAM;
            }
            case 't': {
                return EqlValueType.BOOL;
            }
            case 'f': {
                return EqlValueType.BOOL;
            }
            case '\'': {
                return EqlValueType.STRING;
            }
        }
        if (Character.isDigit(firstChar)) {
            return EqlValueType.NUMBER;
        }
        throw new IllegalArgumentException("Unexpected first character in value [" + valueAsText + "]");
    }

    private void addBetweenProperty(String rawValue, String lowProperty, String highProperty) {
        this.peekExprList().betweenProperties(lowProperty, highProperty, this.bind(rawValue));
    }

    private void addBetween(String path, String value1, String value2) {
        this.peekExprList().between(path, this.bind(value1), this.bind(value2));
    }

    private void addInRange(String path, String value1, String value2) {
        this.peekExprList().inRange(path, this.bind(value1), this.bind(value2));
    }

    private void addExpression(String path, EqlOperator op, String value) {
        switch (op) {
            case EQ: {
                this.peekExprList().eq(path, this.bind(value));
                break;
            }
            case IEQ: {
                this.peekExprList().add(this.ieq(path, this.bind(value)));
                break;
            }
            case NE: {
                this.peekExprList().ne(path, this.bind(value));
                break;
            }
            case INE: {
                this.peekExprList().add(this.ine(path, this.bind(value)));
                break;
            }
            case GT: {
                this.peekExprList().gt(path, this.bind(value));
                break;
            }
            case LT: {
                this.peekExprList().lt(path, this.bind(value));
                break;
            }
            case GTE: {
                this.peekExprList().ge(path, this.bind(value));
                break;
            }
            case LTE: {
                this.peekExprList().le(path, this.bind(value));
                break;
            }
            case LIKE: {
                this.addLike(false, LikeType.RAW, path, this.bind(value));
                break;
            }
            case CONTAINS: {
                this.addLike(false, LikeType.CONTAINS, path, this.bind(value));
                break;
            }
            case STARTS_WITH: {
                this.addLike(false, LikeType.STARTS_WITH, path, this.bind(value));
                break;
            }
            case ENDS_WITH: {
                this.addLike(false, LikeType.ENDS_WITH, path, this.bind(value));
                break;
            }
            case ILIKE: {
                this.addLike(true, LikeType.RAW, path, this.bind(value));
                break;
            }
            case ICONTAINS: {
                this.addLike(true, LikeType.CONTAINS, path, this.bind(value));
                break;
            }
            case ISTARTS_WITH: {
                this.addLike(true, LikeType.STARTS_WITH, path, this.bind(value));
                break;
            }
            case IENDS_WITH: {
                this.addLike(true, LikeType.ENDS_WITH, path, this.bind(value));
                break;
            }
            case EQORNULL: {
                this.peekExprList().eqOrNull(path, this.bind(value));
                break;
            }
            case GTORNULL: {
                this.peekExprList().gtOrNull(path, this.bind(value));
                break;
            }
            case LTORNULL: {
                this.peekExprList().ltOrNull(path, this.bind(value));
                break;
            }
            case GEORNULL: {
                this.peekExprList().geOrNull(path, this.bind(value));
                break;
            }
            case LEORNULL: {
                this.peekExprList().leOrNull(path, this.bind(value));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + (Object)((Object)op));
            }
        }
    }

    private void addLike(boolean caseInsensitive, LikeType likeType, String path, Object bindValue) {
        this.peekExprList().add(this.like(caseInsensitive, likeType, path, bindValue));
    }

    private Object bind(String value) {
        return this.getBindValue(this.getValueType(value), value);
    }

    private Object getBindValue(EqlValueType valueType, String value) {
        switch (valueType) {
            case BOOL: {
                return Boolean.parseBoolean(value);
            }
            case NUMBER: {
                return new BigDecimal(value);
            }
            case STRING: {
                return this.unquote(value);
            }
            case POS_PARAM: {
                return this.positionParam(value);
            }
            case NAMED_PARAM: {
                return this.namedParam(value.substring(1));
            }
        }
        throw new IllegalArgumentException("Unhandled valueType " + (Object)((Object)valueType));
    }

    private String unquote(String value) {
        return value.substring(1, value.length() - 1);
    }
}

