/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.el;

import io.avaje.lang.NonNullApi;
import io.ebean.Filter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElComparator;
import io.ebeaninternal.server.el.ElMatchBuilder;
import io.ebeaninternal.server.el.ElMatcher;
import io.ebeaninternal.server.el.ElPropertyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

@NonNullApi
public final class ElFilter<T>
implements Filter<T> {
    private final BeanDescriptor<T> beanDescriptor;
    private final ArrayList<ElMatcher<T>> matches = new ArrayList();
    private int maxRows;
    private String sortByClause;

    public ElFilter(BeanDescriptor<T> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    private Object convertValue(String propertyName, Object value) {
        ElPropertyValue elGetValue = this.beanDescriptor.elGetValue(propertyName);
        return elGetValue.convert(value);
    }

    private ElComparator<T> getElComparator(String propertyName) {
        return this.beanDescriptor.elComparator(propertyName);
    }

    private ElPropertyValue getElGetValue(String propertyName) {
        return this.beanDescriptor.elGetValue(propertyName);
    }

    public Filter<T> sort(String sortByClause) {
        this.sortByClause = sortByClause;
        return this;
    }

    protected boolean isMatch(T bean) {
        for (ElMatcher<T> matcher : this.matches) {
            if (matcher.isMatch(bean)) continue;
            return false;
        }
        return true;
    }

    public Filter<T> in(String propertyName, Set<?> matchingValues) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.InSet(matchingValues, elGetValue));
        return this;
    }

    public Filter<T> eq(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Eq<T>(value, comparator));
        return this;
    }

    public Filter<T> ne(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Ne<T>(value, comparator));
        return this;
    }

    public Filter<T> between(String propertyName, Object min, Object max) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        min = elGetValue.convert(min);
        max = elGetValue.convert(max);
        ElComparator<T> elComparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Between<T>(min, max, elComparator));
        return this;
    }

    public Filter<T> gt(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Gt<T>(value, comparator));
        return this;
    }

    public Filter<T> ge(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Ge<T>(value, comparator));
        return this;
    }

    public Filter<T> ieq(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.Ieq(elGetValue, value));
        return this;
    }

    public Filter<T> isNotNull(String propertyName) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IsNotNull(elGetValue));
        return this;
    }

    public Filter<T> isNull(String propertyName) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IsNull(elGetValue));
        return this;
    }

    public Filter<T> le(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Le<T>(value, comparator));
        return this;
    }

    public Filter<T> lt(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Lt<T>(value, comparator));
        return this;
    }

    public Filter<T> regex(String propertyName, String regEx) {
        return this.regex(propertyName, regEx, 0);
    }

    public Filter<T> regex(String propertyName, String regEx, int options) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, regEx, options));
        return this;
    }

    public Filter<T> contains(String propertyName, String value) {
        String quote = ".*" + Pattern.quote(value) + ".*";
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, quote, 0));
        return this;
    }

    public Filter<T> icontains(String propertyName, String value) {
        String quote = ".*" + Pattern.quote(value) + ".*";
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, quote, 2));
        return this;
    }

    public Filter<T> endsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.EndsWith(elGetValue, value));
        return this;
    }

    public Filter<T> startsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.StartsWith(elGetValue, value));
        return this;
    }

    public Filter<T> iendsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IEndsWith(elGetValue, value));
        return this;
    }

    public Filter<T> istartsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IStartsWith(elGetValue, value));
        return this;
    }

    public Filter<T> maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public List<T> filter(List<T> list) {
        if (this.sortByClause != null) {
            list = new ArrayList<T>(list);
            this.beanDescriptor.sort(list, this.sortByClause);
        }
        ArrayList<T> filterList = new ArrayList<T>();
        for (T t : list) {
            if (!this.isMatch(t)) continue;
            filterList.add(t);
            if (this.maxRows <= 0 || filterList.size() < this.maxRows) continue;
            break;
        }
        return filterList;
    }
}

