/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.DbForeignKey;
import io.ebean.annotation.FetchPreference;
import io.ebean.annotation.HistoryExclude;
import io.ebean.annotation.Where;
import io.ebean.bean.BeanCollection;
import io.ebean.config.NamingConvention;
import io.ebean.config.TableName;
import io.ebean.core.type.ScalarType;
import io.ebean.util.CamelCaseHelper;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployOrderColumn;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import io.ebeaninternal.server.deploy.parse.AnnotationAssoc;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import io.ebeaninternal.server.query.SqlJoinType;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EnumType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;

final class AnnotationAssocManys
extends AnnotationAssoc {
    AnnotationAssocManys(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig, BeanDescriptorManager factory) {
        super(info, readConfig, factory);
    }

    @Override
    public void parse() {
        for (DeployBeanProperty prop : this.descriptor.propertiesAll()) {
            if (!(prop instanceof DeployBeanPropertyAssocMany)) continue;
            this.read((DeployBeanPropertyAssocMany)prop);
        }
    }

    private boolean readOrphanRemoval(OneToMany property) {
        try {
            return property.orphanRemoval();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private void read(DeployBeanPropertyAssocMany<?> prop) {
        JoinTable joinTable;
        FetchPreference fetchPreference;
        Where where;
        MapKey mapKey;
        OrderBy orderBy;
        DbForeignKey dbForeignKey;
        ElementCollection elementCollection;
        ManyToMany manyToMany;
        OneToMany oneToMany = this.get(prop, OneToMany.class);
        if (oneToMany != null) {
            OrderColumn orderColumn;
            this.readToOne(oneToMany, prop);
            if (this.readOrphanRemoval(oneToMany)) {
                prop.setOrphanRemoval();
                prop.setModifyListenMode(BeanCollection.ModifyListenMode.REMOVALS);
                prop.getCascadeInfo().setDelete(true);
            }
            if ((orderColumn = this.get(prop, OrderColumn.class)) != null) {
                prop.setOrderColumn(new DeployOrderColumn(orderColumn));
                prop.setFetchOrderBy("orderColumn");
                prop.getCascadeInfo().setType(CascadeType.ALL);
                prop.setModifyListenMode(BeanCollection.ModifyListenMode.ALL);
            }
        }
        if ((manyToMany = this.get(prop, ManyToMany.class)) != null) {
            this.readToMany(manyToMany, prop);
        }
        if ((elementCollection = this.get(prop, ElementCollection.class)) != null) {
            this.readElementCollection(prop, elementCollection);
        }
        if ((dbForeignKey = this.get(prop, DbForeignKey.class)) != null) {
            prop.setForeignKey(new PropertyForeignKey(dbForeignKey));
        }
        if (this.get(prop, HistoryExclude.class) != null) {
            prop.setExcludedFromHistory();
        }
        if ((orderBy = this.get(prop, OrderBy.class)) != null) {
            prop.setFetchOrderBy(orderBy.value());
        }
        if ((mapKey = this.get(prop, MapKey.class)) != null) {
            prop.setMapKey(mapKey.name());
        }
        if ((where = prop.getMetaAnnotationWhere(this.platform)) != null) {
            prop.setExtraWhere(this.processFormula(where.clause()));
        }
        if ((fetchPreference = this.get(prop, FetchPreference.class)) != null) {
            prop.setFetchPreference(fetchPreference.value());
        }
        BeanTable beanTable = prop.getBeanTable();
        Set<JoinColumn> joinColumns = this.annotationJoinColumns(prop);
        if (!joinColumns.isEmpty()) {
            prop.getTableJoin().addJoinColumn(this.util, true, joinColumns, beanTable);
        }
        if ((joinTable = this.get(prop, JoinTable.class)) != null) {
            if (prop.isManyToMany()) {
                this.readJoinTable(joinTable, prop);
            } else {
                prop.setO2mJoinTable();
                this.readJoinTable(joinTable, prop);
                this.manyToManyDefaultJoins(prop);
            }
        } else if (prop.isManyToMany()) {
            this.checkSelfManyToMany(prop);
        }
        if (prop.getMappedBy() != null) {
            return;
        }
        if (prop.isManyToMany()) {
            this.manyToManyDefaultJoins(prop);
            return;
        }
        if (!prop.getTableJoin().hasJoinColumns() && beanTable != null) {
            NamingConvention nc = this.factory.namingConvention();
            String fkeyPrefix = null;
            if (nc.isUseForeignKeyPrefix()) {
                fkeyPrefix = nc.getColumnFromProperty(this.descriptor.getBeanType(), this.descriptor.getName());
            }
            BeanTable owningBeanTable = this.factory.beanTable(this.descriptor.getBeanType());
            owningBeanTable.createJoinColumn(fkeyPrefix, prop.getTableJoin(), false, prop.getSqlFormulaSelect());
        }
    }

    private void checkSelfManyToMany(DeployBeanPropertyAssocMany<?> prop) {
        if (prop.getTargetType().equals(this.descriptor.getBeanType())) {
            throw new IllegalStateException("@ManyToMany mapping for " + prop.getFullBeanName() + " requires explicit @JoinTable with joinColumns & inverseJoinColumns. Refer issue #2157");
        }
    }

    private void readElementCollection(DeployBeanPropertyAssocMany<?> prop, ElementCollection elementCollection) {
        DeployBeanProperty valueProp;
        BeanProperty localId;
        CollectionTable collectionTable;
        String fullTableName;
        Column column;
        prop.setElementCollection();
        if (!elementCollection.targetClass().equals(Void.TYPE)) {
            prop.setTargetType(elementCollection.targetClass());
        }
        if ((column = prop.getMetaAnnotation(Column.class)) != null) {
            prop.setDbColumn(column.name());
            prop.setDbLength(column.length());
            prop.setDbScale(column.scale());
        }
        if ((fullTableName = this.getFullTableName(collectionTable = this.get(prop, CollectionTable.class))) == null) {
            fullTableName = this.descriptor.getBaseTable() + "_" + CamelCaseHelper.toUnderscoreFromCamel((String)prop.getName());
        }
        BeanTable localTable = this.factory.beanTable(this.descriptor.getBeanType());
        if (collectionTable != null) {
            prop.getTableJoin().addJoinColumn(this.util, true, collectionTable.joinColumns(), localTable);
        }
        if (!prop.getTableJoin().hasJoinColumns() && (localId = localTable.getIdProperty()) != null) {
            String fkColName = this.namingConvention.getForeignKey(this.descriptor.getBaseTable(), localId.name());
            prop.getTableJoin().addJoinColumn(new DeployTableJoinColumn(localId.dbColumn(), fkColName));
        }
        BeanTable beanTable = this.factory.createCollectionBeanTable(fullTableName, prop.getTargetType());
        prop.setBeanTable(beanTable);
        Class elementType = prop.getTargetType();
        DeployBeanDescriptor elementDescriptor = this.factory.createDeployDescriptor(elementType);
        elementDescriptor.setBaseTable(new TableName(fullTableName), this.readConfig.getAsOfViewSuffix(), this.readConfig.getVersionsBetweenSuffix());
        int sortOrder = 0;
        if (!prop.getManyType().isMap()) {
            elementDescriptor.setProperties(new String[]{"value"});
        } else {
            elementDescriptor.setProperties(new String[]{"key", "value"});
            String dbKeyColumn = "mkey";
            MapKeyColumn mapKeyColumn = this.get(prop, MapKeyColumn.class);
            if (mapKeyColumn != null) {
                dbKeyColumn = mapKeyColumn.name();
            }
            ScalarType<?> keyScalarType = this.util.getTypeManager().getScalarType(prop.getMapKeyType());
            DeployBeanProperty keyProp = new DeployBeanProperty(elementDescriptor, elementType, keyScalarType, null);
            this.setElementProperty(keyProp, "key", dbKeyColumn, sortOrder++);
            elementDescriptor.addBeanProperty(keyProp);
            if (mapKeyColumn != null) {
                keyProp.setDbLength(mapKeyColumn.length());
                keyProp.setDbScale(mapKeyColumn.scale());
                keyProp.setUnique(mapKeyColumn.unique());
            }
        }
        ScalarType<?> valueScalarType = this.util.getTypeManager().getScalarType(elementType);
        if (valueScalarType == null && elementType.isEnum()) {
            Class enumClass = elementType;
            valueScalarType = this.util.getTypeManager().createEnumScalarType(enumClass, EnumType.STRING);
        }
        boolean scalar = true;
        if (valueScalarType == null) {
            scalar = false;
            valueProp = new DeployBeanPropertyAssocOne(elementDescriptor, elementType);
            valueProp.setName("value");
            valueProp.setEmbedded();
            valueProp.setElementProperty();
            valueProp.setSortOrder(sortOrder++);
            elementDescriptor.addBeanProperty(valueProp);
        } else {
            Lob lob;
            valueProp = new DeployBeanProperty(elementDescriptor, elementType, valueScalarType, null);
            this.setElementProperty(valueProp, "value", prop.getDbColumn(), sortOrder++);
            if (column != null) {
                valueProp.setDbLength(column.length());
                valueProp.setDbScale(column.scale());
            }
            if ((lob = this.get(prop, Lob.class)) != null) {
                this.util.setLobType(valueProp);
            }
            elementDescriptor.addBeanProperty(valueProp);
        }
        elementDescriptor.setName(prop.getFullBeanName());
        this.factory.createUnidirectional(elementDescriptor, prop.getOwningType(), beanTable, prop.getTableJoin());
        prop.setElementDescriptor(this.factory.createElementDescriptor(elementDescriptor, prop.getManyType(), scalar));
    }

    private void setElementProperty(DeployBeanProperty elementProp, String name, String dbColumn, int sortOrder) {
        if (dbColumn == null) {
            dbColumn = "value";
        }
        elementProp.setName(name);
        elementProp.setDbColumn(dbColumn);
        elementProp.setNullable(false);
        elementProp.setDbInsertable(true);
        elementProp.setDbUpdateable(true);
        elementProp.setDbRead(true);
        elementProp.setSortOrder(sortOrder);
        elementProp.setElementProperty();
    }

    private void readJoinTable(JoinTable joinTable, DeployBeanPropertyAssocMany<?> prop) {
        String intTableName = this.getFullTableName(joinTable);
        if (intTableName.isEmpty()) {
            BeanTable localTable = this.factory.beanTable(this.descriptor.getBeanType());
            BeanTable otherTable = this.factory.beanTable(prop.getTargetType());
            intTableName = this.getM2MJoinTableName(localTable, otherTable);
        }
        DeployTableJoin intJoin = new DeployTableJoin();
        intJoin.setTable(intTableName);
        intJoin.addJoinColumn(this.util, true, joinTable.joinColumns(), prop.getBeanTable());
        DeployTableJoin destJoin = prop.getTableJoin();
        destJoin.addJoinColumn(this.util, false, joinTable.inverseJoinColumns(), prop.getBeanTable());
        intJoin.setType(SqlJoinType.OUTER);
        DeployTableJoin inverseDest = destJoin.createInverse(intTableName);
        prop.setIntersectionJoin(intJoin);
        prop.setInverseJoin(inverseDest);
    }

    private String getFullTableName(JoinTable joinTable) {
        return this.append(joinTable.catalog(), joinTable.schema(), joinTable.name());
    }

    private String getFullTableName(CollectionTable collectionTable) {
        if (collectionTable == null || collectionTable.name().isEmpty()) {
            return null;
        }
        return this.append(collectionTable.catalog(), collectionTable.schema(), collectionTable.name());
    }

    private String append(String catalog, String schema, String name) {
        return this.namingConvention.getTableName(catalog, schema, name);
    }

    private void manyToManyDefaultJoins(DeployBeanPropertyAssocMany<?> prop) {
        BeanProperty otherId;
        String fkCol;
        BeanProperty localId;
        String intTableName = null;
        DeployTableJoin intJoin = prop.getIntersectionJoin();
        if (intJoin == null) {
            intJoin = new DeployTableJoin();
            prop.setIntersectionJoin(intJoin);
        } else {
            intTableName = intJoin.getTable();
        }
        BeanTable localTable = this.factory.beanTable(this.descriptor.getBeanType());
        BeanTable otherTable = this.factory.beanTable(prop.getTargetType());
        String localTableName = localTable.getUnqualifiedBaseTable();
        String otherTableName = otherTable.getUnqualifiedBaseTable();
        if (intTableName == null) {
            intTableName = this.getM2MJoinTableName(localTable, otherTable);
            intJoin.setTable(intTableName);
            intJoin.setType(SqlJoinType.OUTER);
        }
        DeployTableJoin destJoin = prop.getTableJoin();
        if (intJoin.hasJoinColumns() && destJoin.hasJoinColumns()) {
            return;
        }
        if (!intJoin.hasJoinColumns() && (localId = localTable.getIdProperty()) != null) {
            fkCol = this.namingConvention.deriveM2MColumn(localTableName, localId.dbColumn());
            intJoin.addJoinColumn(new DeployTableJoinColumn(localId.dbColumn(), fkCol));
        }
        if (!destJoin.hasJoinColumns() && (otherId = otherTable.getIdProperty()) != null) {
            fkCol = this.namingConvention.deriveM2MColumn(otherTableName, otherId.dbColumn());
            destJoin.addJoinColumn(new DeployTableJoinColumn(fkCol, otherId.dbColumn()));
        }
        DeployTableJoin inverseDest = destJoin.createInverse(intTableName);
        prop.setInverseJoin(inverseDest);
    }

    private void readToMany(ManyToMany propAnn, DeployBeanPropertyAssocMany<?> manyProp) {
        manyProp.setMappedBy(propAnn.mappedBy());
        manyProp.setFetchType(propAnn.fetch());
        this.setCascadeTypes(propAnn.cascade(), manyProp.getCascadeInfo());
        this.setTargetType(propAnn.targetEntity(), manyProp);
        this.setBeanTable(manyProp);
        manyProp.setManyToMany();
        manyProp.setModifyListenMode(BeanCollection.ModifyListenMode.ALL);
        manyProp.getTableJoin().setType(SqlJoinType.OUTER);
    }

    private void readToOne(OneToMany propAnn, DeployBeanPropertyAssocMany<?> manyProp) {
        manyProp.setMappedBy(propAnn.mappedBy());
        manyProp.setFetchType(propAnn.fetch());
        this.setCascadeTypes(propAnn.cascade(), manyProp.getCascadeInfo());
        this.setTargetType(propAnn.targetEntity(), manyProp);
        this.setBeanTable(manyProp);
        manyProp.getTableJoin().setType(SqlJoinType.OUTER);
    }

    private String getM2MJoinTableName(BeanTable lhsTable, BeanTable rhsTable) {
        TableName lhs = new TableName(lhsTable.getBaseTable());
        TableName rhs = new TableName(rhsTable.getBaseTable());
        TableName joinTable = this.namingConvention.getM2MJoinTableName(lhs, rhs);
        return joinTable.getQualifiedName();
    }
}

