/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.generatedproperty;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;

final class GeneratedCounter
implements GeneratedProperty {
    private final int numberType;

    GeneratedCounter(int numberType) {
        this.numberType = numberType;
    }

    @Override
    public Object getInsertValue(BeanProperty prop, EntityBean bean, long now) {
        return BasicTypeConverter.convert(1, this.numberType);
    }

    @Override
    public Object getUpdateValue(BeanProperty prop, EntityBean bean, long now) {
        Number currVal = (Number)prop.getValue(bean);
        if (currVal == null) {
            throw new IllegalStateException("version property has been set to null on bean: " + bean);
        }
        Integer nextVal = currVal.intValue() + 1;
        return BasicTypeConverter.convert(nextVal, this.numberType);
    }

    @Override
    public boolean includeInUpdate() {
        return true;
    }

    @Override
    public boolean includeInAllUpdates() {
        return false;
    }

    @Override
    public boolean includeInInsert() {
        return true;
    }

    @Override
    public boolean isDDLNotNullable() {
        return true;
    }
}

