/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionAdd;
import io.ebean.bean.EntityBean;
import io.ebean.common.BeanMap;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BaseCollectionHelp;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanMapHelp<T>
extends BaseCollectionHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final BeanDescriptor<T> targetDescriptor;
    private final String propertyName;
    private final BeanProperty beanProperty;

    BeanMapHelp(BeanPropertyAssocMany<T> many) {
        this.many = many;
        this.targetDescriptor = many.targetDescriptor();
        this.propertyName = many.name();
        this.beanProperty = this.targetDescriptor.beanProperty(many.mapKey());
    }

    @Override
    public BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        if (mapKey == null) {
            mapKey = this.many.mapKey();
        }
        BeanProperty beanProp = this.targetDescriptor.beanProperty(mapKey);
        if (bc instanceof BeanMap) {
            BeanMap bm = (BeanMap)bc;
            LinkedHashMap<Object, Object> actualMap = bm.getActualMap();
            if (actualMap == null) {
                actualMap = new LinkedHashMap<Object, Object>();
                bm.setActualMap(actualMap);
            }
            return new Adder(beanProp, actualMap);
        }
        throw new RuntimeException("Unhandled type " + bc);
    }

    @Override
    public BeanCollection<T> createEmptyNoParent() {
        return new BeanMap();
    }

    @Override
    public BeanCollection<T> createEmpty(EntityBean ownerBean) {
        BeanMap beanMap = new BeanMap(this.loader, ownerBean, this.propertyName);
        if (this.many != null) {
            beanMap.setModifyListening(this.many.modifyListenMode());
        }
        return beanMap;
    }

    @Override
    public void add(BeanCollection<?> collection, EntityBean bean, boolean withCheck) {
        if (bean == null) {
            ((BeanMap)collection).internalPutNull();
        } else {
            Object keyValue = this.beanProperty.getValueIntercept(bean);
            BeanMap map = (BeanMap)collection;
            map.internalPutWithCheck(keyValue, (Object)bean);
        }
    }

    @Override
    public BeanCollection<T> createReference(EntityBean parentBean) {
        BeanMap beanMap = new BeanMap(this.loader, parentBean, this.propertyName);
        if (this.many != null) {
            beanMap.setModifyListening(this.many.modifyListenMode());
        }
        return beanMap;
    }

    @Override
    public void refresh(SpiEbeanServer server, Query<?> query, Transaction t, EntityBean parentBean) {
        BeanMap newBeanMap = (BeanMap)server.findMap(query, t);
        this.refresh((BeanCollection<?>)newBeanMap, parentBean);
    }

    @Override
    public void refresh(BeanCollection<?> bc, EntityBean parentBean) {
        BeanMap newBeanMap = (BeanMap)bc;
        Map current = (Map)this.many.getValue(parentBean);
        newBeanMap.setModifyListening(this.many.modifyListenMode());
        if (current == null) {
            this.many.setValue(parentBean, newBeanMap);
        } else if (current instanceof BeanMap) {
            BeanMap currentBeanMap = (BeanMap)current;
            currentBeanMap.setActualMap(newBeanMap.getActualMap());
            currentBeanMap.setModifyListening(this.many.modifyListenMode());
        } else {
            this.many.setValue(parentBean, newBeanMap);
        }
    }

    @Override
    public void jsonWrite(SpiJsonWriter ctx, String name, Object collection, boolean explicitInclude) throws IOException {
        Map map;
        if (collection instanceof BeanCollection) {
            BeanMap bc = (BeanMap)collection;
            if (!bc.isPopulated()) {
                if (explicitInclude) {
                    bc.size();
                } else {
                    return;
                }
            }
            map = bc.getActualMap();
        } else {
            map = (Map)collection;
        }
        if (!map.isEmpty() || ctx.isIncludeEmpty()) {
            boolean elementCollection = this.many.isElementCollection();
            ctx.beginAssocManyMap(name, elementCollection);
            for (Map.Entry entry : map.entrySet()) {
                this.many.jsonWriteMapEntry(ctx, entry);
            }
            ctx.endAssocManyMap(elementCollection);
        }
    }

    static class Adder
    implements BeanCollectionAdd {
        private final BeanProperty beanProperty;
        private final Map<Object, Object> map;

        Adder(BeanProperty beanProperty, Map<Object, Object> map) {
            this.beanProperty = beanProperty;
            this.map = map;
        }

        public void addEntityBean(EntityBean bean) {
            Object keyValue = this.beanProperty.getValue(bean);
            this.map.put(keyValue, bean);
        }
    }
}

