/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanFindController;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;

final class BeanFinderManager {
    private static final Logger log = CoreLog.internal;
    private final List<BeanFindController> list;

    BeanFinderManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanFindControllers();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addFindControllers(DeployBeanDescriptor<?> deployDesc) {
        for (BeanFindController c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            log.debug("BeanFindController on[{}] {}", (Object)deployDesc.getFullName(), (Object)c.getClass().getName());
            deployDesc.setBeanFinder(c);
        }
    }
}

