/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonParser;
import io.ebean.bean.EntityBean;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptorElement;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.ElementCollector;
import io.ebeaninternal.server.deploy.ElementHelp;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

class BeanDescriptorElementScalarMap<T>
extends BeanDescriptorElement<T> {
    private final ScalarType scalarTypeKey;
    private final ScalarType scalarTypeVal;
    private final boolean stringKey;

    BeanDescriptorElementScalarMap(BeanDescriptorMap owner, DeployBeanDescriptor<T> deploy, ElementHelp elementHelp) {
        super(owner, deploy, elementHelp);
        Object[] props = this.propertiesNonTransient();
        if (props.length != 2) {
            throw new IllegalStateException("Expecting 2 properties for key and value but got " + Arrays.toString(props));
        }
        this.scalarTypeKey = props[0].scalarType();
        this.scalarTypeVal = ((BeanProperty)props[1]).scalarType();
        this.stringKey = String.class.equals((Object)this.scalarTypeKey.getType());
    }

    @Override
    public void jsonWriteMapEntry(SpiJsonWriter ctx, Map.Entry<?, ?> entry) throws IOException {
        if (this.stringKey) {
            Object key = entry.getKey();
            String keyName = key == null ? "null" : key.toString();
            ctx.writeFieldName(keyName);
            this.scalarTypeVal.jsonWrite(ctx.gen(), entry.getValue());
        } else {
            ctx.writeFieldName("key");
            this.scalarTypeKey.jsonWrite(ctx.gen(), entry.getKey());
            ctx.writeFieldName("value");
            this.scalarTypeVal.jsonWrite(ctx.gen(), entry.getValue());
        }
    }

    @Override
    public Object jsonReadCollection(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        String fieldName;
        JsonParser parser = readJson.getParser();
        ElementCollector add = this.elementHelp.createCollector();
        while ((fieldName = parser.nextFieldName()) != null) {
            if (this.stringKey) {
                parser.nextToken();
                Object val = this.scalarTypeVal.jsonRead(parser);
                add.addKeyValue(fieldName, val);
                continue;
            }
            parser.nextFieldName();
            Object key = this.scalarTypeKey.jsonRead(parser);
            parser.nextFieldName();
            Object val = this.scalarTypeVal.jsonRead(parser);
            add.addKeyValue(key, val);
        }
        return add.collection();
    }
}

