/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core.bootup;

import io.ebean.util.StringHelper;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.util.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;

class ManifestReader {
    private static final Logger log = CoreLog.internal;
    private final Set<String> packageSet = new HashSet<String>();
    private final ClassLoader classLoader;

    static ManifestReader create(ClassLoader classLoader) {
        return new ManifestReader(classLoader);
    }

    private ManifestReader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    ManifestReader read(String resourcePath) {
        this.read(this.classLoader, resourcePath);
        return this;
    }

    Set<String> entityPackages() {
        return this.packageSet;
    }

    private Set<String> read(ClassLoader classLoader, String resourcePath) {
        try {
            Enumeration<URL> resources = classLoader.getResources(resourcePath);
            while (resources.hasMoreElements()) {
                InputStream is = UrlHelper.openNoCache(resources.nextElement());
                try {
                    this.read(new Manifest(is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.warn("Error reading " + resourcePath + " manifest resources", (Throwable)e);
        }
        return this.packageSet;
    }

    private void read(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        String agentOnlyUse = attributes.getValue("agent-use-only");
        if (agentOnlyUse == null || !"true".equalsIgnoreCase(agentOnlyUse.trim())) {
            this.add(attributes.getValue("packages"));
            this.add(attributes.getValue("entity-packages"));
        }
    }

    private void add(String packages) {
        if (packages != null) {
            Collections.addAll(this.packageSet, StringHelper.splitNames((String)packages));
        }
    }
}

