/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.ModifyAwareType;
import io.ebeaninternal.json.ModifyAwareFlag;
import io.ebeaninternal.json.ModifyAwareList;
import io.ebeaninternal.json.ModifyAwareMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

final class EJsonReader {
    static final JsonFactory json = new JsonFactory();
    private final JsonParser parser;
    private final boolean modifyAware;
    private final ModifyAwareFlag modifyAwareOwner;
    private int depth;
    private Stack stack;
    private Context currentContext;

    static Map<String, Object> parseObject(String json, boolean modifyAware) throws IOException {
        return (Map)EJsonReader.parse(json, modifyAware);
    }

    static Map<String, Object> parseObject(String json) throws IOException {
        return (Map)EJsonReader.parse(json);
    }

    static Map<String, Object> parseObject(Reader reader) throws IOException {
        return (Map)EJsonReader.parse(reader);
    }

    static Map<String, Object> parseObject(Reader reader, boolean modifyAware) throws IOException {
        return (Map)EJsonReader.parse(reader, modifyAware);
    }

    static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        return (Map)EJsonReader.parse(parser);
    }

    static Map<String, Object> parseObject(JsonParser parser, JsonToken token) throws IOException {
        return (Map)EJsonReader.parse(parser, token, false);
    }

    static <T> List<T> parseList(String json, boolean modifyAware) throws IOException {
        return (List)EJsonReader.parse(json, modifyAware);
    }

    static List<Object> parseList(String json) throws IOException {
        return (List)EJsonReader.parse(json);
    }

    static List<Object> parseList(Reader reader) throws IOException {
        return (List)EJsonReader.parse(reader);
    }

    static List<Object> parseList(JsonParser parser, boolean modifyAware) throws IOException {
        return (List)EJsonReader.parse(parser, modifyAware);
    }

    static Object parse(String json) throws IOException {
        if (json == null) {
            return null;
        }
        return EJsonReader.parse(new StringReader(json));
    }

    static Object parse(String json, boolean modifyAware) throws IOException {
        if (json == null) {
            return null;
        }
        return EJsonReader.parse(new StringReader(json), modifyAware);
    }

    static Object parse(Reader reader) throws IOException {
        return EJsonReader.parse(json.createParser(reader));
    }

    static Object parse(Reader reader, boolean modifyAware) throws IOException {
        return EJsonReader.parse(json.createParser(reader), modifyAware);
    }

    static Object parse(JsonParser parser) throws IOException {
        return EJsonReader.parse(parser, null, false);
    }

    static Object parse(JsonParser parser, boolean modifyAware) throws IOException {
        return EJsonReader.parse(parser, null, modifyAware);
    }

    static Object parse(JsonParser parser, JsonToken token, boolean modifyAware) throws IOException {
        return new EJsonReader(parser, modifyAware).parseJson(token);
    }

    EJsonReader(JsonParser parser, boolean modifyAware) {
        this.parser = parser;
        this.modifyAware = modifyAware;
        this.modifyAwareOwner = modifyAware ? new ModifyAwareFlag() : null;
    }

    private void startArray() {
        ++this.depth;
        this.stack.push(this.currentContext);
        this.currentContext = this.modifyAware ? new ArrayContext(this.modifyAwareOwner) : new ArrayContext();
    }

    private void startObject() {
        ++this.depth;
        this.stack.push(this.currentContext);
        this.currentContext = this.modifyAware ? new ObjectContext(this.modifyAwareOwner) : new ObjectContext();
    }

    private void endArray() {
        this.end();
    }

    private void endObject() {
        this.end();
    }

    private void end() {
        --this.depth;
        if (!this.stack.isEmpty()) {
            this.currentContext = this.stack.pop(this.currentContext);
        }
        if (this.modifyAwareOwner != null) {
            this.modifyAwareOwner.setMarkedDirty(false);
        }
    }

    private void setValue(Object value) {
        this.currentContext.setValue(value);
    }

    private void setValueNull() {
        this.currentContext.setValueNull();
    }

    private Object parseJson(JsonToken token) throws IOException {
        if (token == null) {
            token = this.parser.nextToken();
            switch (token) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_FALSE: {
                    return Boolean.FALSE;
                }
                case VALUE_TRUE: {
                    return Boolean.TRUE;
                }
                case VALUE_STRING: {
                    return this.parser.getText();
                }
                case VALUE_NUMBER_INT: {
                    return this.parser.getLongValue();
                }
                case VALUE_NUMBER_FLOAT: {
                    return this.parser.getDecimalValue();
                }
            }
        }
        this.stack = new Stack();
        this.processJsonToken(token);
        while (this.depth > 0) {
            token = this.parser.nextToken();
            this.processJsonToken(token);
        }
        return this.currentContext.getValue();
    }

    private void processJsonToken(JsonToken token) throws IOException {
        switch (token) {
            case START_ARRAY: {
                this.startArray();
                break;
            }
            case START_OBJECT: {
                this.startObject();
                break;
            }
            case FIELD_NAME: {
                this.currentContext.setKey(this.parser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                this.setValue(this.parser.getValueAsString());
                break;
            }
            case VALUE_NUMBER_INT: {
                this.setValue(this.parser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.setValue(this.parser.getDecimalValue());
                break;
            }
            case VALUE_TRUE: {
                this.setValue(Boolean.TRUE);
                break;
            }
            case VALUE_FALSE: {
                this.setValue(Boolean.FALSE);
                break;
            }
            case VALUE_NULL: {
                this.setValueNull();
                break;
            }
            case END_OBJECT: {
                this.endObject();
                break;
            }
            case END_ARRAY: {
                this.endArray();
                break;
            }
        }
    }

    private static class ArrayContext
    extends Context {
        private final List<Object> values;

        ArrayContext() {
            this.values = new ArrayList<Object>();
        }

        ArrayContext(ModifyAwareType owner) {
            this.values = new ModifyAwareList<Object>(owner, new ArrayList());
        }

        @Override
        public void popContext(Context temp) {
            this.values.add(temp.getValue());
        }

        @Override
        Object getValue() {
            return this.values;
        }

        @Override
        void setValue(Object value) {
            this.values.add(value);
        }

        @Override
        void setValueNull() {
        }

        @Override
        void setKey(String key) {
        }
    }

    private static class ObjectContext
    extends Context {
        private final Map<String, Object> map;
        private String key;

        ObjectContext() {
            this.map = new LinkedHashMap<String, Object>();
        }

        ObjectContext(ModifyAwareType owner) {
            this.map = new ModifyAwareMap<String, Object>(owner, new LinkedHashMap());
        }

        @Override
        public void popContext(Context temp) {
            this.setValue(temp.getValue());
        }

        @Override
        Object getValue() {
            return this.map;
        }

        @Override
        void setKey(String key) {
            this.key = key;
        }

        @Override
        void setValue(Object value) {
            this.map.put(this.key, value);
        }

        @Override
        void setValueNull() {
            this.map.put(this.key, null);
        }
    }

    private static abstract class Context {
        Context next;

        private Context() {
        }

        abstract void popContext(Context var1);

        abstract Object getValue();

        abstract void setKey(String var1);

        abstract void setValue(Object var1);

        abstract void setValueNull();
    }

    private static final class Stack {
        private Context head;

        private Stack() {
        }

        private void push(Context context) {
            if (context != null) {
                context.next = this.head;
                this.head = context;
            }
        }

        private Context pop(Context endingContext) {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Context temp = this.head;
            this.head = this.head.next;
            temp.popContext(endingContext);
            return temp;
        }

        private boolean isEmpty() {
            return this.head == null;
        }
    }
}

