/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeJsonMapPostgres;
import io.ebeaninternal.server.type.TypeJsonManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;

public abstract class ScalarTypeJsonMap
extends ScalarTypeBase<Map> {
    private static final ScalarTypeJsonMap CLOB = new Clob();
    private static final ScalarTypeJsonMap BLOB = new Blob();
    private static final ScalarTypeJsonMap VARCHAR = new Varchar();
    private static final ScalarTypeJsonMap JSON = new ScalarTypeJsonMapPostgres.JSON();
    private static final ScalarTypeJsonMap JSONB = new ScalarTypeJsonMapPostgres.JSONB();

    public static ScalarTypeJsonMap typeFor(boolean postgres, int dbType) {
        switch (dbType) {
            case 12: {
                return VARCHAR;
            }
            case 2004: {
                return BLOB;
            }
            case 2005: {
                return CLOB;
            }
            case 5002: {
                return postgres ? JSONB : CLOB;
            }
            case 5001: {
                return postgres ? JSON : CLOB;
            }
        }
        throw new IllegalStateException("Unknown dbType " + dbType);
    }

    public ScalarTypeJsonMap(int jdbcType) {
        super(Map.class, false, jdbcType);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return TypeJsonManager.checkIsDirty(value);
    }

    public Map read(DataReader reader) throws SQLException {
        String rawJson = reader.getString();
        if (rawJson == null) {
            return null;
        }
        return this.parse(rawJson);
    }

    public void bind(DataBinder binder, Map value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            String rawJson = this.formatValue(value);
            binder.setString(rawJson);
        }
    }

    public Object toJdbcType(Object value) {
        return value;
    }

    public Map toBeanType(Object value) {
        return (Map)value;
    }

    public String formatValue(Map v) {
        try {
            return EJson.write((Object)v);
        }
        catch (IOException e) {
            throw new TextException((Exception)e);
        }
    }

    public Map parse(String value) {
        try {
            return EJson.parseObject((String)value, (boolean)true);
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as Object", value, (Exception)e);
        }
    }

    public Map parse(Reader reader) {
        try {
            return EJson.parseObject((Reader)reader, (boolean)true);
        }
        catch (IOException e) {
            throw new TextException((Exception)e);
        }
    }

    public Map convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    public void writeData(DataOutput dataOutput, Map map) throws IOException {
        if (map == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(map));
        }
    }

    public void jsonWrite(JsonGenerator writer, Map value) throws IOException {
        EJson.write((Object)value, (JsonGenerator)writer);
    }

    public Map jsonRead(JsonParser parser) throws IOException {
        return EJson.parseObject((JsonParser)parser, (JsonToken)parser.getCurrentToken());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.OBJECT;
    }

    public static class Clob
    extends ScalarTypeJsonMap {
        public Clob() {
            super(2005);
        }

        @Override
        public Map read(DataReader reader) throws SQLException {
            String content = reader.getStringFromStream();
            if (content == null) {
                return null;
            }
            return this.parse(content);
        }
    }

    public static class Blob
    extends ScalarTypeJsonMap {
        public Blob() {
            super(2004);
        }

        @Override
        public Map read(DataReader reader) throws SQLException {
            Map map;
            InputStream is = reader.getBinaryStream();
            if (is == null) {
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(is);
            try {
                map = this.parse(inputStreamReader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("Error reading Blob stream from DB", e);
                }
            }
            inputStreamReader.close();
            return map;
        }

        @Override
        public void bind(DataBinder binder, Map value) throws SQLException {
            if (value == null) {
                binder.setNull(2004);
            } else {
                String rawJson = this.formatValue(value);
                binder.setBytes(rawJson.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static class Varchar
    extends ScalarTypeJsonMap {
        public Varchar() {
            super(12);
        }
    }
}

