/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;

class JacksonTypeHelper {
    private final AnnotatedField field;
    private final ObjectMapper objectMapper;
    private final JavaType javaType;
    private final DeserializationConfig deserConfig;
    private final AnnotationIntrospector ai;

    JacksonTypeHelper(AnnotatedField field, ObjectMapper objectMapper) {
        this.field = field;
        this.objectMapper = objectMapper;
        this.javaType = field.getType();
        this.deserConfig = objectMapper.getDeserializationConfig();
        this.ai = this.deserConfig.getAnnotationIntrospector();
    }

    JavaType type() {
        if (this.ai == null || this.javaType == null || this.javaType.hasRawClass(Object.class)) {
            return this.javaType;
        }
        try {
            return this.ai.refineDeserializationType((MapperConfig)this.deserConfig, (Annotated)this.field, this.javaType);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    ObjectWriter objectWriter() {
        if (this.ai == null || this.javaType == null || this.javaType.hasRawClass(Object.class)) {
            return this.objectMapper.writerFor(this.javaType);
        }
        try {
            JavaType serType = this.ai.refineSerializationType((MapperConfig)this.objectMapper.getSerializationConfig(), (Annotated)this.field, this.javaType);
            return this.objectMapper.writerFor(serType);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }
}

