/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBind
implements DataBinder {
    private static final Logger log = LoggerFactory.getLogger(DataBind.class);
    private final DataTimeZone dataTimeZone;
    private final PreparedStatement pstmt;
    private final Connection connection;
    private final StringBuilder bindLog = new StringBuilder();
    private List<InputStream> inputStreams;
    protected int pos;
    private String json;

    public DataBind(DataTimeZone dataTimeZone, PreparedStatement pstmt, Connection connection) {
        this.dataTimeZone = dataTimeZone;
        this.pstmt = pstmt;
        this.connection = connection;
    }

    public void pushJson(String json) {
        assert (this.json == null);
        this.json = json;
    }

    public String popJson() {
        String ret = this.json;
        this.json = null;
        return ret;
    }

    public StringBuilder append(Object entry) {
        return this.bindLog.append(entry);
    }

    public StringBuilder log() {
        return this.bindLog;
    }

    public void close() throws SQLException {
        this.pstmt.close();
    }

    public int currentPos() {
        return this.pos;
    }

    public void setObject(Object value) throws SQLException {
        this.pstmt.setObject(++this.pos, value);
    }

    public void setObject(Object value, int sqlType) throws SQLException {
        this.pstmt.setObject(++this.pos, value, sqlType);
    }

    public void setNull(int jdbcType) throws SQLException {
        this.pstmt.setNull(++this.pos, jdbcType);
    }

    public int nextPos() {
        return ++this.pos;
    }

    public void decrementPos() {
        --this.pos;
    }

    public int executeUpdate() throws SQLException {
        try {
            int n = this.pstmt.executeUpdate();
            return n;
        }
        finally {
            this.closeInputStreams();
        }
    }

    private void closeInputStreams() {
        if (this.inputStreams != null) {
            for (InputStream inputStream : this.inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warn("Error closing InputStream that was bound to PreparedStatement", (Throwable)e);
                }
            }
            this.inputStreams = null;
        }
    }

    public PreparedStatement getPstmt() {
        return this.pstmt;
    }

    public void setString(String s) throws SQLException {
        this.pstmt.setString(++this.pos, s);
    }

    public void setInt(int i) throws SQLException {
        this.pstmt.setInt(++this.pos, i);
    }

    public void setLong(long i) throws SQLException {
        this.pstmt.setLong(++this.pos, i);
    }

    public void setShort(short i) throws SQLException {
        this.pstmt.setShort(++this.pos, i);
    }

    public void setFloat(float i) throws SQLException {
        this.pstmt.setFloat(++this.pos, i);
    }

    public void setDouble(double i) throws SQLException {
        this.pstmt.setDouble(++this.pos, i);
    }

    public void setBigDecimal(BigDecimal v) throws SQLException {
        this.pstmt.setBigDecimal(++this.pos, v);
    }

    public void setDate(Date v) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getDateTimeZone();
        if (timeZone != null) {
            this.pstmt.setDate(++this.pos, v, timeZone);
        } else {
            this.pstmt.setDate(++this.pos, v);
        }
    }

    public void setTimestamp(Timestamp v) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getTimeZone();
        if (timeZone != null) {
            this.pstmt.setTimestamp(++this.pos, v, timeZone);
        } else {
            this.pstmt.setTimestamp(++this.pos, v);
        }
    }

    public void setTime(Time v) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getTimeZone();
        if (timeZone != null) {
            this.pstmt.setTime(++this.pos, v, timeZone);
        } else {
            this.pstmt.setTime(++this.pos, v);
        }
    }

    public void setBoolean(boolean v) throws SQLException {
        this.pstmt.setBoolean(++this.pos, v);
    }

    public void setBytes(byte[] v) throws SQLException {
        this.pstmt.setBytes(++this.pos, v);
    }

    public void setByte(byte v) throws SQLException {
        this.pstmt.setByte(++this.pos, v);
    }

    public void setChar(char v) throws SQLException {
        this.pstmt.setString(++this.pos, String.valueOf(v));
    }

    public List<InputStream> getInputStreams() {
        return this.inputStreams;
    }

    public void setBinaryStream(InputStream inputStream, long length) throws SQLException {
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(inputStream);
        this.pstmt.setBinaryStream(++this.pos, inputStream, length);
    }

    public void setBlob(byte[] bytes) throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.pstmt.setBinaryStream(++this.pos, (InputStream)is, bytes.length);
    }

    public void setClob(String content) throws SQLException {
        StringReader reader = new StringReader(content);
        this.pstmt.setCharacterStream(++this.pos, (Reader)reader, content.length());
    }

    public void setArray(String arrayType, Object[] elements) throws SQLException {
        Array array = this.connection.createArrayOf(arrayType, elements);
        this.pstmt.setArray(++this.pos, array);
    }
}

