/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.FetchConfig;
import io.ebean.OrderBy;
import io.ebean.Query;
import io.ebean.event.BeanQueryRequest;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionFactory;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.FilterExprPath;
import io.ebeaninternal.server.expression.FilterExpressionList;
import io.ebeaninternal.server.querydefn.OrmQueryPropertiesParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OrmQueryProperties
implements Serializable {
    private static final long serialVersionUID = -8785582703966455658L;
    static final FetchConfig DEFAULT_FETCH = FetchConfig.ofDefault();
    private final String parentPath;
    private final String path;
    private final boolean allProperties;
    private final Set<String> included;
    private final FetchConfig fetchConfig;
    private final boolean cache;
    private boolean markForQueryJoin;
    private Set<String> includedBeanJoin;
    private Set<String> secondaryQueryJoins;
    private List<OrmQueryProperties> secondaryChildren;
    private OrderBy orderBy;
    private SpiExpressionList filterMany;

    public OrmQueryProperties() {
        this(null);
    }

    public OrmQueryProperties(String path) {
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.allProperties = false;
        this.included = null;
        this.cache = false;
        this.fetchConfig = DEFAULT_FETCH;
    }

    public OrmQueryProperties(String path, String rawProperties) {
        this(path, rawProperties, DEFAULT_FETCH);
    }

    public OrmQueryProperties(String path, String rawProperties, FetchConfig fetchConfig) {
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        OrmQueryPropertiesParser.Response response = OrmQueryPropertiesParser.parse(rawProperties);
        this.allProperties = response.allProperties;
        this.included = response.included;
        if (fetchConfig != null) {
            this.fetchConfig = fetchConfig;
            this.cache = fetchConfig.isCache();
        } else {
            this.cache = false;
            this.fetchConfig = DEFAULT_FETCH;
        }
    }

    public OrmQueryProperties(String path, Set<String> included) {
        this(path, included, DEFAULT_FETCH);
    }

    OrmQueryProperties(String path, Set<String> included, FetchConfig fetchConfig) {
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.included = included;
        this.allProperties = false;
        this.fetchConfig = fetchConfig;
        this.cache = fetchConfig.isCache();
    }

    OrmQueryProperties(String path, OrmQueryProperties other, FetchConfig fetchConfig) {
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.allProperties = other.allProperties;
        this.included = other.included;
        this.fetchConfig = fetchConfig;
        this.cache = fetchConfig.isCache();
    }

    private OrmQueryProperties(OrmQueryProperties source, FetchConfig sourceFetchConfig) {
        this.fetchConfig = sourceFetchConfig;
        this.parentPath = source.parentPath;
        this.path = source.path;
        this.allProperties = source.allProperties;
        this.cache = source.cache;
        this.filterMany = source.filterMany;
        this.markForQueryJoin = source.markForQueryJoin;
        this.included = source.included == null ? null : new LinkedHashSet<String>(source.included);
    }

    public OrmQueryProperties copy() {
        return new OrmQueryProperties(this, this.fetchConfig);
    }

    public OrmQueryProperties copy(FetchConfig fetchConfig) {
        return new OrmQueryProperties(this, fetchConfig);
    }

    void addSecJoinOrderProperty(OrderBy.Property orderProp) {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        this.orderBy.add(orderProp);
    }

    public FetchConfig getFetchConfig() {
        return this.fetchConfig;
    }

    public <T> SpiExpressionList<T> filterMany(Query<T> rootQuery) {
        if (this.filterMany == null) {
            FilterExprPath exprPath = new FilterExprPath(this.path);
            SpiExpressionFactory queryEf = (SpiExpressionFactory)rootQuery.getExpressionFactory();
            ExpressionFactory filterEf = queryEf.createExpressionFactory();
            this.filterMany = new FilterExpressionList<T>(exprPath, filterEf, rootQuery);
        }
        return this.filterMany;
    }

    private SpiExpressionList<?> getFilterManyTrimPath(int trimPath) {
        if (this.filterMany == null) {
            return null;
        }
        return this.filterMany.trimPath(trimPath);
    }

    public void filterManyInline() {
        if (this.filterMany != null) {
            this.filterMany.prefixProperty(this.path);
        }
    }

    public void prepareExpressions(BeanQueryRequest<?> request) {
        if (this.filterMany != null) {
            this.filterMany.prepareExpression(request);
        }
    }

    public SpiExpressionList<?> getFilterMany() {
        return this.filterMany;
    }

    public void setFilterMany(SpiExpressionList<?> filterMany) {
        this.filterMany = filterMany;
    }

    public void configureBeanQuery(SpiQuery<?> query) {
        if (this.hasProperties()) {
            query.selectProperties(this);
        }
        if (this.filterMany != null) {
            this.filterMany.applyRowLimits(query);
            SpiExpressionList<?> trimPath = this.filterMany.trimPath(this.path.length() + 1);
            for (SpiExpression spiExpression : trimPath.getUnderlyingList()) {
                query.where().add((Expression)spiExpression);
            }
        }
        if (this.secondaryChildren != null) {
            int trimPath = this.path.length() + 1;
            for (OrmQueryProperties p : this.secondaryChildren) {
                String path = p.getPath();
                path = path.substring(trimPath);
                query.fetchProperties(path, p);
                query.setFilterMany(path, p.getFilterManyTrimPath(trimPath));
            }
        }
        if (this.orderBy != null) {
            query.setOrder(this.orderBy.copyWithTrim(this.path));
        }
    }

    public boolean hasSelectClause() {
        return this.allProperties || this.included != null || this.filterMany != null;
    }

    boolean hasProperties() {
        return this.allProperties || this.included != null;
    }

    public void asStringDebug(String prefix, StringBuilder sb) {
        sb.append(prefix);
        if (this.path != null) {
            sb.append(this.path).append(" ");
        }
        if (this.allProperties) {
            sb.append("(*)");
        } else if (this.included != null) {
            sb.append("(").append(String.join((CharSequence)",", this.included)).append(")");
        }
    }

    boolean isChild(OrmQueryProperties possibleChild) {
        return possibleChild.getPath().startsWith(this.path + ".");
    }

    public void add(OrmQueryProperties child) {
        if (this.secondaryChildren == null) {
            this.secondaryChildren = new ArrayList<OrmQueryProperties>();
        }
        this.secondaryChildren.add(child);
    }

    public boolean allProperties() {
        return this.included == null;
    }

    public boolean isIncludedBeanJoin(String propertyName) {
        return this.includedBeanJoin != null && this.includedBeanJoin.contains(propertyName);
    }

    void includeBeanJoin(String propertyName) {
        if (this.includedBeanJoin == null) {
            this.includedBeanJoin = new HashSet<String>();
        }
        this.includedBeanJoin.add(propertyName);
    }

    public Set<String> getSelectQueryJoin() {
        return this.secondaryQueryJoins;
    }

    void addSecondaryQueryJoin(String property) {
        if (this.secondaryQueryJoins == null) {
            this.secondaryQueryJoins = new HashSet<String>(4);
        }
        this.secondaryQueryJoins.add(property);
    }

    public Set<String> getIncluded() {
        return this.included;
    }

    boolean isIncluded(String propName) {
        if (this.includedBeanJoin != null && this.includedBeanJoin.contains(propName)) {
            return false;
        }
        return this.included == null || this.included.contains(propName);
    }

    void markForQueryJoin() {
        this.markForQueryJoin = true;
    }

    public boolean isQueryFetch() {
        return this.markForQueryJoin || this.cache || this.fetchConfig.isQuery();
    }

    boolean isFetchJoin() {
        return !this.markForQueryJoin && this.fetchConfig.isJoin();
    }

    boolean isLazyFetch() {
        return this.fetchConfig.isLazy();
    }

    public int getBatchSize() {
        return this.fetchConfig.getBatchSize();
    }

    public boolean isCache() {
        return this.cache;
    }

    String getParentPath() {
        return this.parentPath;
    }

    public String getPath() {
        return this.path;
    }

    boolean isSameByAutoTune(OrmQueryProperties p2) {
        if (this.included == null) {
            return p2 == null || p2.included == null;
        }
        if (p2 == null) {
            return false;
        }
        return this.included.equals(p2.included);
    }

    public void queryPlanHash(StringBuilder builder) {
        builder.append("{");
        if (this.path != null) {
            builder.append(this.path);
        }
        if (this.included != null) {
            builder.append("/i").append(this.included);
        }
        if (this.secondaryQueryJoins != null) {
            builder.append("/s").append(this.secondaryQueryJoins);
        }
        if (this.filterMany != null) {
            builder.append("/f");
            this.filterMany.queryPlanHash(builder);
        }
        if (this.fetchConfig != null) {
            builder.append("/c").append(this.fetchConfig.hashCode());
        }
        builder.append("}");
    }
}

