/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.query.CQueryPlan;

public final class CQueryPlanStats {
    private final CQueryPlan queryPlan;
    private final TimedMetric timedMetric;
    private boolean collected;
    private long lastQueryTime;

    CQueryPlanStats(CQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
        this.timedMetric = queryPlan.createTimedMetric();
    }

    public boolean isEmpty() {
        return this.timedMetric.isEmpty();
    }

    public void add(long timeMicros) {
        this.timedMetric.add(timeMicros);
        this.lastQueryTime = System.currentTimeMillis();
    }

    public void reset() {
        this.timedMetric.reset();
    }

    long getLastQueryTime() {
        return this.lastQueryTime;
    }

    Snapshot getSnapshot(boolean reset) {
        TimedMetricStats collect = this.timedMetric.collect(reset);
        Snapshot snapshot = new Snapshot(this.collected, this.queryPlan, collect);
        this.collected = true;
        return snapshot;
    }

    static class Snapshot
    implements MetaQueryMetric {
        private final boolean collected;
        private final CQueryPlan queryPlan;
        private final TimedMetricStats metrics;

        Snapshot(boolean collected, CQueryPlan queryPlan, TimedMetricStats metrics) {
            this.collected = collected;
            this.queryPlan = queryPlan;
            this.metrics = metrics;
        }

        public String toString() {
            return "label:" + this.label() + " location:" + this.location() + " metrics:" + this.metrics + " sql:" + this.sql();
        }

        public Class<?> type() {
            return this.queryPlan.getBeanType();
        }

        public String label() {
            return this.queryPlan.getLabel();
        }

        public String name() {
            return this.queryPlan.getName();
        }

        public String location() {
            return this.queryPlan.getLocation();
        }

        public long locationHash() {
            return this.queryPlan.getLocationHash();
        }

        public long count() {
            return this.metrics.count();
        }

        public long total() {
            return this.metrics.total();
        }

        public long max() {
            return this.metrics.max();
        }

        public long mean() {
            return this.metrics.mean();
        }

        public long sqlHash() {
            return this.queryPlan.getSqlHash();
        }

        public String sql() {
            return this.queryPlan.getSql();
        }

        public boolean initialCollection() {
            return !this.collected;
        }
    }
}

