/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DProfileLocation;
import io.ebeaninternal.server.profile.TimedProfileLocation;

class DTimedProfileLocation
extends DProfileLocation
implements TimedProfileLocation {
    private final String label;
    private final TimedMetric timedMetric;
    private final boolean overrideMetricName;
    private String fullName;

    DTimedProfileLocation(int lineNumber, String label, TimedMetric timedMetric) {
        super(lineNumber);
        this.label = label;
        this.timedMetric = timedMetric;
        this.overrideMetricName = "".equals(label);
    }

    @Override
    protected void initWith(String locationLabel) {
        if (this.overrideMetricName) {
            this.fullName = "txn.named." + locationLabel;
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public TimedMetric getMetric() {
        return this.timedMetric;
    }

    @Override
    public void add(long executionTime) {
        this.timedMetric.add(executionTime);
    }

    @Override
    public void visit(MetricVisitor visitor) {
        TimedMetricStats collect = this.timedMetric.collect(visitor.reset());
        if (collect != null) {
            if (this.overrideMetricName) {
                collect.setName(this.fullName);
            }
            collect.setLocation(this.location());
            visitor.visitTimed((MetaTimedMetric)collect);
        }
    }
}

