/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dmlbind;

import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.BeanPropertyJsonMapper;
import io.ebeaninternal.server.persist.dml.DmlMode;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableAssocOne;
import io.ebeaninternal.server.persist.dmlbind.BindableEncryptedProperty;
import io.ebeaninternal.server.persist.dmlbind.BindableProperty;
import io.ebeaninternal.server.persist.dmlbind.BindablePropertyJsonInsert;
import io.ebeaninternal.server.persist.dmlbind.BindablePropertyJsonUpdate;

class FactoryProperty {
    private final boolean bindEncryptDataFirst;

    FactoryProperty(boolean bindEncryptDataFirst) {
        this.bindEncryptDataFirst = bindEncryptDataFirst;
    }

    public Bindable create(BeanProperty prop, DmlMode mode, boolean withLobs, boolean allowManyToOne) {
        if (DmlMode.INSERT == mode && !prop.isDbInsertable()) {
            return null;
        }
        if (DmlMode.UPDATE == mode && !prop.isDbUpdatable()) {
            return null;
        }
        if (prop.isLob() && !withLobs) {
            return null;
        }
        if (prop.isDbEncrypted()) {
            return new BindableEncryptedProperty(prop, this.bindEncryptDataFirst);
        }
        if (allowManyToOne && prop instanceof BeanPropertyAssocOne) {
            return new BindableAssocOne((BeanPropertyAssocOne)prop);
        }
        if (prop instanceof BeanPropertyJsonMapper) {
            if (DmlMode.INSERT == mode) {
                return new BindablePropertyJsonInsert(prop);
            }
            if (DmlMode.UPDATE == mode) {
                return new BindablePropertyJsonUpdate(prop);
            }
        }
        return new BindableProperty(prop);
    }
}

