/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.CacheMode;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.CallOrigin;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.ObjectGraphOrigin;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadContext;
import io.ebeaninternal.api.LoadSecondaryQuery;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.loadcontext.DLoadBeanContext;
import io.ebeaninternal.server.loadcontext.DLoadManyContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLoadContext
implements LoadContext {
    private final SpiEbeanServer ebeanServer;
    private final BeanDescriptor<?> rootDescriptor;
    private final Map<String, DLoadBeanContext> beanMap = new HashMap<String, DLoadBeanContext>();
    private final Map<String, DLoadManyContext> manyMap = new HashMap<String, DLoadManyContext>();
    private final DLoadBeanContext rootBeanContext;
    private final boolean asDraft;
    private final Timestamp asOf;
    private final Boolean readOnly;
    private final CacheMode useBeanCache;
    private final int defaultBatchSize;
    private final boolean disableLazyLoading;
    private final boolean disableReadAudit;
    private final boolean includeSoftDeletes;
    final boolean useDocStore;
    private final String relativePath;
    private final ObjectGraphOrigin origin;
    private final String planLabel;
    private final ProfileLocation profileLocation;
    private final ProfilingListener profilingListener;
    private final Map<String, ObjectGraphNode> nodePathMap = new HashMap<String, ObjectGraphNode>();
    private PersistenceContext persistenceContext;
    private List<OrmQueryProperties> secQuery;
    private Object tenantId;

    public DLoadContext(BeanDescriptor<?> rootDescriptor, PersistenceContext persistenceContext) {
        this.useDocStore = true;
        this.rootDescriptor = rootDescriptor;
        this.ebeanServer = rootDescriptor.getEbeanServer();
        this.persistenceContext = persistenceContext;
        this.origin = this.initOrigin();
        this.defaultBatchSize = 100;
        this.useBeanCache = CacheMode.OFF;
        this.asDraft = false;
        this.asOf = null;
        this.readOnly = false;
        this.disableLazyLoading = false;
        this.disableReadAudit = false;
        this.includeSoftDeletes = false;
        this.relativePath = null;
        this.planLabel = null;
        this.profileLocation = null;
        this.profilingListener = null;
        this.rootBeanContext = new DLoadBeanContext(this, rootDescriptor, null, null);
    }

    private ObjectGraphOrigin initOrigin() {
        CallOrigin callOrigin = this.ebeanServer.createCallOrigin();
        return new ObjectGraphOrigin(0, callOrigin, this.rootDescriptor.getFullName());
    }

    public DLoadContext(OrmQueryRequest<?> request, SpiQuerySecondary secondaryQueries) {
        this.tenantId = request.getTenantId();
        this.persistenceContext = request.getPersistenceContext();
        this.ebeanServer = request.getServer();
        this.defaultBatchSize = request.getLazyLoadBatchSize();
        this.rootDescriptor = request.getBeanDescriptor();
        Query query = request.getQuery();
        this.useDocStore = query.isUseDocStore();
        this.asOf = query.getAsOf();
        this.asDraft = query.isAsDraft();
        this.includeSoftDeletes = query.isIncludeSoftDeletes();
        this.readOnly = query.isReadOnly();
        this.disableReadAudit = query.isDisableReadAudit();
        this.disableLazyLoading = query.isDisableLazyLoading();
        this.useBeanCache = query.getUseBeanCache();
        this.profilingListener = query.getProfilingListener();
        this.planLabel = query.getPlanLabel();
        this.profileLocation = query.getProfileLocation();
        ObjectGraphNode parentNode = query.getParentNode();
        if (parentNode != null) {
            this.origin = parentNode.getOriginQueryPoint();
            this.relativePath = parentNode.getPath();
        } else {
            this.origin = null;
            this.relativePath = null;
        }
        this.rootBeanContext = new DLoadBeanContext(this, this.rootDescriptor, null, null);
        this.registerSecondaryQueries(secondaryQueries);
    }

    String getPlanLabel() {
        return this.planLabel;
    }

    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    private void registerSecondaryQueries(SpiQuerySecondary secondaryQueries) {
        List<OrmQueryProperties> lazyJoins;
        this.secQuery = secondaryQueries.getQueryJoins();
        if (this.secQuery != null) {
            for (OrmQueryProperties pathProperties : this.secQuery) {
                this.registerSecondaryQuery(pathProperties);
            }
        }
        if ((lazyJoins = secondaryQueries.getLazyJoins()) != null) {
            for (OrmQueryProperties lazyJoin : lazyJoins) {
                this.registerSecondaryQuery(lazyJoin);
            }
        }
    }

    private void registerSecondaryQuery(OrmQueryProperties props) {
        ElPropertyValue elGetValue = this.rootDescriptor.getElGetValue(props.getPath());
        boolean many = elGetValue.getBeanProperty().containsMany();
        this.registerSecondaryNode(many, props);
    }

    boolean isBeanCacheGet() {
        return this.useBeanCache.isGet();
    }

    @Override
    public int getSecondaryQueriesMinBatchSize() {
        if (this.secQuery == null) {
            return -1;
        }
        int maxBatch = 0;
        for (OrmQueryProperties aSecQuery : this.secQuery) {
            int batchSize = aSecQuery.getBatchSize();
            if (batchSize == 0) {
                batchSize = 100;
            }
            maxBatch = Math.max(maxBatch, batchSize);
        }
        return maxBatch;
    }

    @Override
    public void executeSecondaryQueries(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (this.secQuery != null) {
            for (OrmQueryProperties aSecQuery : this.secQuery) {
                LoadSecondaryQuery load = this.getLoadSecondaryQuery(aSecQuery.getPath());
                load.loadSecondaryQuery(parentRequest, forEach);
            }
        }
    }

    private LoadSecondaryQuery getLoadSecondaryQuery(String path) {
        LoadSecondaryQuery beanLoad = this.beanMap.get(path);
        return beanLoad == null ? (LoadSecondaryQuery)this.manyMap.get(path) : beanLoad;
    }

    @Override
    public ObjectGraphNode getObjectGraphNode(String path) {
        return this.nodePathMap.computeIfAbsent(path, this::createObjectGraphNode);
    }

    private ObjectGraphNode createObjectGraphNode(String path) {
        if (this.relativePath != null) {
            path = path == null ? this.relativePath : this.relativePath + "." + path;
        }
        return new ObjectGraphNode(this.origin, path);
    }

    String getFullPath(String path) {
        if (this.relativePath == null) {
            return path;
        }
        return this.relativePath + "." + path;
    }

    protected SpiEbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    protected Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void resetPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
        for (DLoadBeanContext beanContext : this.beanMap.values()) {
            beanContext.clear();
        }
        for (DLoadManyContext manyContext : this.manyMap.values()) {
            manyContext.clear();
        }
        this.rootBeanContext.clear();
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi) {
        this.getBeanContext(path).register(ebi);
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi, BeanPropertyAssocOne<?> property) {
        this.getBeanContextWithInherit(path, property).register(ebi);
    }

    @Override
    public void register(String path, BeanPropertyAssocMany<?> many, BeanCollection<?> bc) {
        this.getManyContext(path, many).register(bc);
    }

    int batchSize(OrmQueryProperties props) {
        if (props == null) {
            return this.defaultBatchSize;
        }
        int batchSize = props.getBatchSize();
        return batchSize == 0 ? this.defaultBatchSize : batchSize;
    }

    DLoadBeanContext getBeanContext(String path) {
        if (path == null) {
            return this.rootBeanContext;
        }
        return this.beanMap.computeIfAbsent(path, p -> this.createBeanContext((String)p, null));
    }

    DLoadBeanContext getBeanContextWithInherit(String path, BeanPropertyAssocOne<?> property) {
        String key = path + ":" + property.getTargetDescriptor().getName();
        return this.beanMap.computeIfAbsent(key, p -> this.createBeanContext(property, path, null));
    }

    private void registerSecondaryNode(boolean many, OrmQueryProperties props) {
        String path = props.getPath();
        if (many) {
            this.manyMap.put(path, this.createManyContext(path, props));
        } else {
            this.beanMap.put(path, this.createBeanContext(path, props));
        }
    }

    DLoadManyContext getManyContext(String path, BeanPropertyAssocMany<?> many) {
        return this.manyMap.computeIfAbsent(path, p -> this.createManyContext((String)p, many));
    }

    private DLoadManyContext createManyContext(String path, BeanPropertyAssocMany<?> many) {
        return new DLoadManyContext(this, many, path, null);
    }

    private DLoadManyContext createManyContext(String path, OrmQueryProperties queryProps) {
        BeanPropertyAssocMany p = (BeanPropertyAssocMany)this.getBeanProperty(this.rootDescriptor, path);
        return new DLoadManyContext(this, p, path, queryProps);
    }

    private DLoadBeanContext createBeanContext(String path, OrmQueryProperties queryProps) {
        BeanPropertyAssoc p = (BeanPropertyAssoc)this.getBeanProperty(this.rootDescriptor, path);
        return new DLoadBeanContext(this, p.getTargetDescriptor(), path, queryProps);
    }

    private DLoadBeanContext createBeanContext(BeanPropertyAssoc<?> property, String path, OrmQueryProperties queryProps) {
        return new DLoadBeanContext(this, property.getTargetDescriptor(), path, queryProps);
    }

    private BeanProperty getBeanProperty(BeanDescriptor<?> desc, String path) {
        return desc.findPropertyFromPath(path);
    }

    void propagateQueryState(SpiQuery<?> query, boolean docStoreMapped) {
        if (this.useDocStore && docStoreMapped) {
            query.setUseDocStore(true);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly);
        }
        query.setDisableLazyLoading(this.disableLazyLoading);
        query.asOf(this.asOf);
        if (this.asDraft) {
            query.asDraft();
        }
        if (this.includeSoftDeletes) {
            query.setIncludeSoftDeletes();
        }
        if (this.disableReadAudit) {
            query.setDisableReadAuditing();
        }
        if (this.profilingListener != null) {
            query.setProfilingListener(this.profilingListener);
        }
        if (this.tenantId != null) {
            query.setTenantId(this.tenantId);
        }
    }
}

