/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression.platform;

import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.BitwiseOp;
import io.ebeaninternal.server.expression.platform.DbExpressionHandler;

abstract class BaseDbExpression
implements DbExpressionHandler {
    BaseDbExpression() {
    }

    @Override
    public void bitwise(SpiExpressionRequest request, String propName, BitwiseOp operator, long flags, String compare, long match) {
        String bitOp = this.bitOp(operator);
        request.append("(").append(propName).append(" ").append(bitOp).append(" ? ").append(compare).append(" ?)");
    }

    private String bitOp(BitwiseOp operator) {
        switch (operator) {
            case ANY: 
            case AND: 
            case ALL: {
                return "&";
            }
        }
        throw new IllegalArgumentException("Unknown Bitwise operator " + (Object)((Object)operator) + " not handled?");
    }

    protected void bitwiseFunction(SpiExpressionRequest request, String propName, BitwiseOp operator, String compare) {
        String funcName = this.functionName(operator);
        request.append(funcName).append("(").append(propName).append(", ?) ").append(compare).append(" ?");
    }

    protected String functionName(BitwiseOp operator) {
        switch (operator) {
            case ANY: 
            case AND: 
            case ALL: {
                return "bitand";
            }
        }
        throw new IllegalArgumentException("Unknown Bitwise operator " + (Object)((Object)operator) + " not handled?");
    }

    @Override
    public String concat(String property0, String separator, String property1, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append("concat(").append(property0).append(",'").append(separator).append("',").append(property1);
        if (suffix != null && !suffix.isEmpty()) {
            sb.append(",'").append(suffix).append('\'');
        }
        sb.append(')');
        return sb.toString();
    }

    String concatOperator(String property0, String separator, String property1, String suffix) {
        StringBuilder sb = new StringBuilder(40);
        sb.append("(").append(property0).append("||'").append(separator).append("'||").append(property1);
        if (suffix != null && !suffix.isEmpty()) {
            sb.append("||'").append(suffix).append('\'');
        }
        sb.append(')');
        return sb.toString();
    }
}

